<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Regraproduto Model
 *
 * @method \App\Model\Entity\Regraproduto get($primaryKey, $options = [])
 * @method \App\Model\Entity\Regraproduto newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Regraproduto[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Regraproduto|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Regraproduto|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Regraproduto patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Regraproduto[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Regraproduto findOrCreate($search, callable $callback = null, $options = [])
 */
class RegraprodutoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('regraproduto');
        $this->setDisplayField('regraprodutoid');
        $this->setPrimaryKey('regraprodutoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('regraprodutoid')
            ->allowEmpty('regraprodutoid', 'create');

        $validator
            ->integer('produtoid')
            ->requirePresence('produtoid', 'create')
            ->notEmpty('produtoid');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->requirePresence('nome', 'create')
            ->notEmpty('nome');

        $validator
            ->integer('qtdparcelas')
            ->requirePresence('qtdparcelas', 'create')
            ->notEmpty('qtdparcelas');

        $validator
            ->integer('pessoaidcadastro')
            ->requirePresence('pessoaidcadastro', 'create')
            ->notEmpty('pessoaidcadastro');

        $validator
            ->dateTime('data_criacao')
            ->requirePresence('data_criacao', 'create')
            ->notEmpty('data_criacao');

        return $validator;
    }
}
