<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Regrarecebimento Model
 *
 * @method \App\Model\Entity\Regrarecebimento get($primaryKey, $options = [])
 * @method \App\Model\Entity\Regrarecebimento newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Regrarecebimento[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Regrarecebimento|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Regrarecebimento|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Regrarecebimento patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Regrarecebimento[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Regrarecebimento findOrCreate($search, callable $callback = null, $options = [])
 */
class RegrarecebimentoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('regrarecebimento');
        $this->setDisplayField('regrarecebimentoid');
        $this->setPrimaryKey('regrarecebimentoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('regrarecebimentoid')
            ->allowEmpty('regrarecebimentoid', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->decimal('percentualtotal')
            ->allowEmpty('percentualtotal');

        $validator
            ->integer('quantidadeparcelas')
            ->allowEmpty('quantidadeparcelas');

        $validator
            ->dateTime('data_criacao')
            ->requirePresence('data_criacao', 'create')
            ->notEmpty('data_criacao');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        return $validator;
    }
}
