<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Regrascomissao Model
 *
 * @method \App\Model\Entity\Regrascomissao get($primaryKey, $options = [])
 * @method \App\Model\Entity\Regrascomissao newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Regrascomissao[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Regrascomissao|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Regrascomissao|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Regrascomissao patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Regrascomissao[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Regrascomissao findOrCreate($search, callable $callback = null, $options = [])
 */
class RegrascomissaoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('regrascomissao');
        $this->setDisplayField('regrascomissaoid');
        $this->setPrimaryKey('regrascomissaoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('regrascomissaoid')
            ->allowEmpty('regrascomissaoid', 'create');

        $validator
            ->integer('empresaid')
            ->requirePresence('empresaid', 'create')
            ->notEmpty('empresaid');

        $validator
            ->decimal('taxacorretora')
            ->requirePresence('taxacorretora', 'create')
            ->notEmpty('taxacorretora');

        $validator
            ->decimal('taxafranquia')
            ->requirePresence('taxafranquia', 'create')
            ->notEmpty('taxafranquia');

        $validator
            ->decimal('taxafranchising')
            ->requirePresence('taxafranchising', 'create')
            ->notEmpty('taxafranchising');

        $validator
            ->dateTime('data_criacao')
            ->requirePresence('data_criacao', 'create')
            ->notEmpty('data_criacao');

        $validator
            ->scalar('nomeregra')
            ->maxLength('nomeregra', 255)
            ->requirePresence('nomeregra', 'create')
            ->notEmpty('nomeregra');

        return $validator;
    }
}
