<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Responsavelcliente Model
 *
 * @method \App\Model\Entity\Responsavelcliente get($primaryKey, $options = [])
 * @method \App\Model\Entity\Responsavelcliente newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Responsavelcliente[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Responsavelcliente|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Responsavelcliente patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Responsavelcliente[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Responsavelcliente findOrCreate($search, callable $callback = null, $options = [])
 */
class ResponsavelclienteTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('responsavelcliente');
        $this->setDisplayField('idresponsavelcliente');
        $this->setPrimaryKey('idresponsavelcliente');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idresponsavelcliente')
            ->allowEmpty('idresponsavelcliente', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 70)
            ->allowEmpty('nome');

        $validator
            ->scalar('datanascimento')
            ->maxLength('datanascimento', 10)
            ->allowEmpty('datanascimento');

        $validator
            ->scalar('observacao')
            ->maxLength('observacao', 8000)
            ->allowEmpty('observacao');

        $validator
            ->scalar('funcao1')
            ->maxLength('funcao1', 50)
            ->allowEmpty('funcao1');

        $validator
            ->scalar('funcao2')
            ->maxLength('funcao2', 50)
            ->allowEmpty('funcao2');

        $validator
            ->scalar('time')
            ->maxLength('time', 50)
            ->allowEmpty('time');

        $validator
            ->scalar('hobby')
            ->maxLength('hobby', 255)
            ->allowEmpty('hobby');

        $validator
            ->scalar('telefone1')
            ->maxLength('telefone1', 15)
            ->allowEmpty('telefone1');

        $validator
            ->scalar('telefone2')
            ->maxLength('telefone2', 15)
            ->allowEmpty('telefone2');

        $validator
            ->email('email')
            ->allowEmpty('email');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->integer('idcliente')
            ->allowEmpty('idcliente');

        $validator
            ->scalar('usuario_criacao')
            ->maxLength('usuario_criacao', 20)
            ->allowEmpty('usuario_criacao');

        return $validator;
    }

    /**
     * Returns a rules checker object that will be used for validating
     * application integrity.
     *
     * @param \Cake\ORM\RulesChecker $rules The rules object to be modified.
     * @return \Cake\ORM\RulesChecker
     */
    public function buildRules(RulesChecker $rules)
    {
        $rules->add($rules->isUnique(['email']));

        return $rules;
    }
}
