<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * RessuprimentoFabricante Model
 *
 * @method \App\Model\Entity\RessuprimentoFabricante get($primaryKey, $options = [])
 * @method \App\Model\Entity\RessuprimentoFabricante newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\RessuprimentoFabricante[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\RessuprimentoFabricante|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\RessuprimentoFabricante patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\RessuprimentoFabricante[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\RessuprimentoFabricante findOrCreate($search, callable $callback = null, $options = [])
 */
class RessuprimentoFabricanteTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('ressuprimento_fabricante');
        $this->setDisplayField('idressuprimento');
        $this->setPrimaryKey('idressuprimento');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idressuprimento')
            ->allowEmpty('idressuprimento', 'create');

        $validator
            ->integer('codfabricanteerp')
            ->allowEmpty('codfabricanteerp');

            $validator
            ->scalar('nomefabricante')
            ->maxLength('nomefabricante', 255)
            ->allowEmpty('nomefabricante');

        $validator
            ->integer('codfornecedorerp')
            ->allowEmpty('codfornecedorerp');

        $validator
            ->integer('qtddias')
            ->allowEmpty('qtddias');

        $validator
            ->integer('idusuario')
            ->allowEmpty('idusuario');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
