<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * SetorCnae Model
 *
 * @method \App\Model\Entity\SetorCnae get($primaryKey, $options = [])
 * @method \App\Model\Entity\SetorCnae newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\SetorCnae[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\SetorCnae|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\SetorCnae patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\SetorCnae[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\SetorCnae findOrCreate($search, callable $callback = null, $options = [])
 */
class SetorCnaeTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('setor_cnae');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->scalar('cnae_fiscal')
            ->maxLength('cnae_fiscal', 50)
            ->allowEmpty('cnae_fiscal');

        $validator
            ->scalar('setor')
            ->maxLength('setor', 100)
            ->allowEmpty('setor');

        return $validator;
    }
}
