<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Statuscontato Model
 *
 * @method \App\Model\Entity\Statuscontato get($primaryKey, $options = [])
 * @method \App\Model\Entity\Statuscontato newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Statuscontato[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Statuscontato|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Statuscontato patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Statuscontato[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Statuscontato findOrCreate($search, callable $callback = null, $options = [])
 */
class StatuscontatoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('statuscontato');
        $this->setDisplayField('statuscontatoid');
        $this->setPrimaryKey('statuscontatoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('statuscontatoid')
            ->allowEmpty('statuscontatoid', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 255)
            ->allowEmpty('descricao');

        $validator
            ->integer('ordem')
            ->allowEmpty('ordem');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        $validator
            ->integer('sucesso')
            ->allowEmpty('sucesso');

        $validator
            ->integer('funilid')
            ->allowEmpty('funilid');

        return $validator;
    }
}
