<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Subgrupo Model
 *
 * @method \App\Model\Entity\Subgrupo get($primaryKey, $options = [])
 * @method \App\Model\Entity\Subgrupo newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Subgrupo[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Subgrupo|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Subgrupo patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Subgrupo[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Subgrupo findOrCreate($search, callable $callback = null, $options = [])
 */
class SubgrupoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('subgrupo');
        $this->setDisplayField('idsubgrupo');
        $this->setPrimaryKey('idsubgrupo');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idsubgrupo')
            ->allowEmpty('idsubgrupo', 'create');

        $validator
            ->scalar('coderp')
            ->maxLength('coderp', 20)
            ->allowEmpty('coderp');

        $validator
            ->integer('idgrupo')
            ->allowEmpty('idgrupo');

        $validator
            ->scalar('subgrupo')
            ->maxLength('subgrupo', 255)
            ->allowEmpty('subgrupo');

        return $validator;
    }
}
