<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Subgrupoproduto Model
 *
 * @method \App\Model\Entity\Subgrupoproduto get($primaryKey, $options = [])
 * @method \App\Model\Entity\Subgrupoproduto newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Subgrupoproduto[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Subgrupoproduto|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Subgrupoproduto patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Subgrupoproduto[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Subgrupoproduto findOrCreate($search, callable $callback = null, $options = [])
 */
class SubgrupoprodutoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('subgrupoproduto');
        $this->setDisplayField('subgrupoprodutoid');
        $this->setPrimaryKey('subgrupoprodutoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('subgrupoprodutoid')
            ->allowEmpty('subgrupoprodutoid', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 255)
            ->allowEmpty('descricao');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
