<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Subtipoconta Model
 *
 * @method \App\Model\Entity\Subtipocontum get($primaryKey, $options = [])
 * @method \App\Model\Entity\Subtipocontum newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Subtipocontum[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Subtipocontum|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Subtipocontum patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Subtipocontum[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Subtipocontum findOrCreate($search, callable $callback = null, $options = [])
 */
class SubtipocontaTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('subtipoconta');
        $this->setDisplayField('subtipocontaid');
        $this->setPrimaryKey('subtipocontaid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('subtipocontaid')
            ->allowEmpty('subtipocontaid', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 220)
            ->requirePresence('nome', 'create')
            ->notEmpty('nome');

        return $validator;
    }
}
