<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Supervisor Model
 *
 * @method \App\Model\Entity\Supervisor get($primaryKey, $options = [])
 * @method \App\Model\Entity\Supervisor newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Supervisor[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Supervisor|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Supervisor patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Supervisor[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Supervisor findOrCreate($search, callable $callback = null, $options = [])
 */
class SupervisorTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('supervisor');
        $this->setDisplayField('idsupervisor');
        $this->setPrimaryKey('idsupervisor');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idsupervisor')
            ->allowEmpty('idsupervisor', 'create');

        $validator
            ->integer('idempresa')
            ->allowEmpty('idempresa');

        $validator
            ->integer('idfilial')
            ->allowEmpty('idfilial');

        $validator
            ->scalar('cod1')
            ->maxLength('cod1', 10)
            ->allowEmpty('cod1');

        $validator
            ->scalar('cod2')
            ->maxLength('cod2', 10)
            ->allowEmpty('cod2');

        $validator
            ->scalar('cod3')
            ->maxLength('cod3', 10)
            ->allowEmpty('cod3');

        $validator
            ->scalar('coderp')
            ->maxLength('coderp', 10)
            ->allowEmpty('coderp');

        $validator
            ->scalar('razaosocial')
            ->maxLength('razaosocial', 255)
            ->allowEmpty('razaosocial');

        $validator
            ->scalar('nomefantasia')
            ->maxLength('nomefantasia', 255)
            ->allowEmpty('nomefantasia');

        $validator
            ->scalar('cpfcnpj')
            ->maxLength('cpfcnpj', 20)
            ->allowEmpty('cpfcnpj');

        $validator
            ->dateTime('data_admissao')
            ->allowEmpty('data_admissao');

        $validator
            ->integer('ativo')
            ->allowEmpty('ativo');

        $validator
            ->scalar('logradouro')
            ->maxLength('logradouro', 255)
            ->allowEmpty('logradouro');

        $validator
            ->scalar('bairro')
            ->maxLength('bairro', 70)
            ->allowEmpty('bairro');

        $validator
            ->scalar('municipio')
            ->maxLength('municipio', 255)
            ->allowEmpty('municipio');

        $validator
            ->scalar('estado')
            ->maxLength('estado', 2)
            ->allowEmpty('estado');

        $validator
            ->scalar('codibgemunicipio')
            ->maxLength('codibgemunicipio', 20)
            ->allowEmpty('codibgemunicipio');

        $validator
            ->scalar('fone1')
            ->maxLength('fone1', 20)
            ->allowEmpty('fone1');

        $validator
            ->scalar('fone2')
            ->maxLength('fone2', 20)
            ->allowEmpty('fone2');

        $validator
            ->scalar('opfone1')
            ->maxLength('opfone1', 20)
            ->allowEmpty('opfone1');

        $validator
            ->scalar('opfone2')
            ->maxLength('opfone2', 20)
            ->allowEmpty('opfone2');

        $validator
            ->scalar('foto')
            ->maxLength('foto', 255)
            ->allowEmpty('foto');

        $validator
            ->scalar('cep')
            ->maxLength('cep', 20)
            ->allowEmpty('cep');

        $validator
            ->scalar('complemento')
            ->maxLength('complemento', 50)
            ->allowEmpty('complemento');

        $validator
            ->scalar('usuario_criacao')
            ->maxLength('usuario_criacao', 20)
            ->allowEmpty('usuario_criacao');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
