<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Supervisorvendedor Model
 *
 * @method \App\Model\Entity\Supervisorvendedor get($primaryKey, $options = [])
 * @method \App\Model\Entity\Supervisorvendedor newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Supervisorvendedor[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Supervisorvendedor|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Supervisorvendedor patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Supervisorvendedor[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Supervisorvendedor findOrCreate($search, callable $callback = null, $options = [])
 */
class SupervisorvendedorTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('supervisorvendedor');
        $this->setDisplayField('idsupervisorvendedor');
        $this->setPrimaryKey('idsupervisorvendedor');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idsupervisorvendedor')
            ->allowEmpty('idsupervisorvendedor', 'create');

        $validator
            ->integer('idsupervisor')
            ->allowEmpty('idsupervisor');

        $validator
            ->integer('idvendedor')
            ->allowEmpty('idvendedor');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
