<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Telefone Model
 *
 * @method \App\Model\Entity\Telefone get($primaryKey, $options = [])
 * @method \App\Model\Entity\Telefone newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Telefone[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Telefone|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Telefone patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Telefone[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Telefone findOrCreate($search, callable $callback = null, $options = [])
 */
class TelefoneTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('telefone');
        $this->setDisplayField('telefoneid');
        $this->setPrimaryKey('telefoneid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('telefoneid')
            ->allowEmpty('telefoneid', 'create');

        $validator
            ->scalar('codigopais')
            ->maxLength('codigopais', 5)
            ->allowEmpty('codigopais');

        $validator
            ->scalar('ddd')
            ->maxLength('ddd', 5)
            ->allowEmpty('ddd');

        $validator
            ->scalar('numero')
            ->maxLength('numero', 20)
            ->allowEmpty('numero');

        $validator
            ->integer('pessoaid')
            ->allowEmpty('pessoaid');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        $validator
            ->scalar('tipotelefone')
            ->maxLength('tipotelefone', 255)
            ->allowEmpty('tipotelefone');

        return $validator;
    }
}
