<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Texto Model
 *
 * @method \App\Model\Entity\Texto get($primaryKey, $options = [])
 * @method \App\Model\Entity\Texto newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Texto[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Texto|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Texto patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Texto[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Texto findOrCreate($search, callable $callback = null, $options = [])
 */
class TextoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('texto');
        $this->setDisplayField('idtexto');
        $this->setPrimaryKey('idtexto');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idtexto')
            ->allowEmpty('idtexto', 'create');

        $validator
            ->scalar('chave')
            ->maxLength('chave', 255)
            ->allowEmpty('chave');

        $validator
            ->scalar('titulo')
            ->maxLength('titulo', 255)
            ->allowEmpty('titulo');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 8000)
            ->allowEmpty('descricao');

        return $validator;
    }
}
