<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Tipoacomodacao Model
 *
 * @method \App\Model\Entity\Tipoacomodacao get($primaryKey, $options = [])
 * @method \App\Model\Entity\Tipoacomodacao newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Tipoacomodacao[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Tipoacomodacao|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Tipoacomodacao|bool saveOrFail(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Tipoacomodacao patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Tipoacomodacao[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Tipoacomodacao findOrCreate($search, callable $callback = null, $options = [])
 */
class TipoacomodacaoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('tipoacomodacao');
        $this->setDisplayField('tipoacomodacaoid');
        $this->setPrimaryKey('tipoacomodacaoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('tipoacomodacaoid')
            ->allowEmpty('tipoacomodacaoid', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 255)
            ->allowEmpty('descricao');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        return $validator;
    }
}
