<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Tipocliente Model
 *
 * @method \App\Model\Entity\Tipocliente get($primaryKey, $options = [])
 * @method \App\Model\Entity\Tipocliente newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Tipocliente[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Tipocliente|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Tipocliente patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Tipocliente[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Tipocliente findOrCreate($search, callable $callback = null, $options = [])
 */
class TipoclienteTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('tipocliente');
        $this->setDisplayField('tipoclienteid');
        $this->setPrimaryKey('tipoclienteid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('tipoclienteid')
            ->allowEmpty('tipoclienteid', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 255)
            ->allowEmpty('descricao');

        $validator
            ->integer('ordem')
            ->allowEmpty('ordem');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        return $validator;
    }
}
