<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Tipocontato Model
 *
 * @method \App\Model\Entity\Tipocontato get($primaryKey, $options = [])
 * @method \App\Model\Entity\Tipocontato newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Tipocontato[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Tipocontato|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Tipocontato patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Tipocontato[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Tipocontato findOrCreate($search, callable $callback = null, $options = [])
 */
class TipocontatoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('tipocontato');
        $this->setDisplayField('tipocontatoid');
        $this->setPrimaryKey('tipocontatoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('tipocontatoid')
            ->allowEmpty('tipocontatoid', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 255)
            ->allowEmpty('descricao');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
