<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Tipoendereco Model
 *
 * @method \App\Model\Entity\Tipoendereco get($primaryKey, $options = [])
 * @method \App\Model\Entity\Tipoendereco newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Tipoendereco[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Tipoendereco|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Tipoendereco patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Tipoendereco[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Tipoendereco findOrCreate($search, callable $callback = null, $options = [])
 */
class TipoenderecoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('tipoendereco');
        $this->setDisplayField('tipoenderecoid');
        $this->setPrimaryKey('tipoenderecoid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('tipoenderecoid')
            ->allowEmpty('tipoenderecoid', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 255)
            ->allowEmpty('descricao');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
