<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Tipolead Model
 *
 * @method \App\Model\Entity\Tipolead get($primaryKey, $options = [])
 * @method \App\Model\Entity\Tipolead newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Tipolead[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Tipolead|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Tipolead patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Tipolead[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Tipolead findOrCreate($search, callable $callback = null, $options = [])
 */
class TipoleadTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('tipolead');
        $this->setDisplayField('tipolead');
        $this->setPrimaryKey('tipolead');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('tipolead')
            ->allowEmpty('tipolead', 'create');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->scalar('descricao')
            ->maxLength('descricao', 255)
            ->allowEmpty('descricao');

        $validator
            ->integer('ordem')
            ->allowEmpty('ordem');

        $validator
            ->integer('pessoaidcadastro')
            ->allowEmpty('pessoaidcadastro');

        $validator
            ->integer('empresaid')
            ->allowEmpty('empresaid');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
