<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * UsuarioCrm Model
 *
 * @method \App\Model\Entity\UsuarioCrm get($primaryKey, $options = [])
 * @method \App\Model\Entity\UsuarioCrm newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\UsuarioCrm[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\UsuarioCrm|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\UsuarioCrm patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\UsuarioCrm[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\UsuarioCrm findOrCreate($search, callable $callback = null, $options = [])
 */
class UsuarioCrmTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('usuario_crm');
        $this->setDisplayField('usuariocrmid');
        $this->setPrimaryKey('usuariocrmid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('usuariocrmid')
            ->allowEmpty('usuariocrmid', 'create');

        $validator
            ->integer('usuarioid')
            ->requirePresence('usuarioid', 'create')
            ->notEmpty('usuarioid');

        $validator
            ->integer('empresaid')
            ->requirePresence('empresaid', 'create')
            ->notEmpty('empresaid');

        $validator
            ->integer('pessoaid')
            ->allowEmpty('pessoaid');

        return $validator;
    }
}
