<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * UsuarioHospital Model
 *
 * @method \App\Model\Entity\UsuarioHospital get($primaryKey, $options = [])
 * @method \App\Model\Entity\UsuarioHospital newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\UsuarioHospital[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\UsuarioHospital|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\UsuarioHospital patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\UsuarioHospital[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\UsuarioHospital findOrCreate($search, callable $callback = null, $options = [])
 */
class UsuarioHospitalTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('usuario_hospital');
        $this->setDisplayField('usuario_hospitalid');
        $this->setPrimaryKey('usuario_hospitalid');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('usuario_hospitalid')
            ->allowEmpty('usuario_hospitalid', 'create');

        $validator
            ->integer('hospitalid')
            ->requirePresence('hospitalid', 'create')
            ->notEmpty('hospitalid');

        $validator
            ->integer('usuarioid')
            ->requirePresence('usuarioid', 'create')
            ->notEmpty('usuarioid');

        return $validator;
    }
}
