<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * UsuarioUnidade Model
 *
 * @method \App\Model\Entity\UsuarioUnidade get($primaryKey, $options = [])
 * @method \App\Model\Entity\UsuarioUnidade newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\UsuarioUnidade[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\UsuarioUnidade|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\UsuarioUnidade patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\UsuarioUnidade[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\UsuarioUnidade findOrCreate($search, callable $callback = null, $options = [])
 */
class UsuarioUnidadeTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('usuario_unidade');
        $this->setDisplayField('idusuario');
        $this->setPrimaryKey('idusuario');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idusuario')
            ->allowEmpty('idusuario', 'create');

        $validator
            ->integer('idusuariocontroladoria')
            ->allowEmpty('idusuariocontroladoria');

        $validator
            ->scalar('nome')
            ->maxLength('nome', 255)
            ->allowEmpty('nome');

        $validator
            ->scalar('tipo')
            ->maxLength('tipo', 50)
            ->allowEmpty('tipo');

        $validator
            ->scalar('cpf')
            ->maxLength('cpf', 20)
            ->allowEmpty('cpf');

        $validator
            ->integer('ativo')
            ->allowEmpty('ativo');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
