<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Usuariofunil Model
 *
 * @method \App\Model\Entity\Usuariofunil get($primaryKey, $options = [])
 * @method \App\Model\Entity\Usuariofunil newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Usuariofunil[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Usuariofunil|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Usuariofunil patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Usuariofunil[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Usuariofunil findOrCreate($search, callable $callback = null, $options = [])
 */
class UsuariofunilTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('usuariofunil');
        $this->setDisplayField('id');
        $this->setPrimaryKey('id');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('id')
            ->allowEmpty('id', 'create');

        $validator
            ->integer('idusuario')
            ->allowEmpty('idusuario');

        $validator
            ->integer('idfunil')
            ->allowEmpty('idfunil');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        return $validator;
    }
}
