<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Visita Model
 *
 * @method \App\Model\Entity\Visitum get($primaryKey, $options = [])
 * @method \App\Model\Entity\Visitum newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Visitum[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Visitum|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Visitum patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Visitum[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Visitum findOrCreate($search, callable $callback = null, $options = [])
 */
class VisitaTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('visita');
        $this->setDisplayField('idvisita');
        $this->setPrimaryKey('idvisita');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idvisita')
            ->allowEmpty('idvisita', 'create');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->scalar('data_visita')
            ->maxLength('data_visita', 20)
            ->allowEmpty('data_visita');

        $validator
            ->scalar('data_visitado')
            ->maxLength('data_visitado', 20)
            ->allowEmpty('data_visitado');

        $validator
            ->scalar('status')
            ->maxLength('status', 20)
            ->allowEmpty('status');

        $validator
            ->integer('idempresa')
            ->allowEmpty('idempresa');

        $validator
            ->integer('idfilial')
            ->allowEmpty('idfilial');

        $validator
            ->integer('idusuario')
            ->allowEmpty('idusuario');

        $validator
            ->integer('idcliente')
            ->allowEmpty('idcliente');

        $validator
            ->integer('idvendedor')
            ->allowEmpty('idvendedor');

        $validator
            ->integer('idsupervisor')
            ->allowEmpty('idsupervisor');

        $validator
            ->scalar('metavalor')
            ->maxLength('metavalor', 20)
            ->allowEmpty('metavalor');

        $validator
            ->scalar('metaunidades')
            ->maxLength('metaunidades', 20)
            ->allowEmpty('metaunidades');

        $validator
            ->scalar('metapercentual')
            ->maxLength('metapercentual', 20)
            ->allowEmpty('metapercentual');

        $validator
            ->scalar('mescomparado')
            ->maxLength('mescomparado', 4)
            ->allowEmpty('mescomparado');

        $validator
            ->scalar('anocomparado')
            ->maxLength('anocomparado', 4)
            ->allowEmpty('anocomparado');

        return $validator;
    }
}
