<?php
namespace App\Model\Table;

use Cake\ORM\Query;
use Cake\ORM\RulesChecker;
use Cake\ORM\Table;
use Cake\Validation\Validator;

/**
 * Visitaapontamento Model
 *
 * @method \App\Model\Entity\Visitaapontamento get($primaryKey, $options = [])
 * @method \App\Model\Entity\Visitaapontamento newEntity($data = null, array $options = [])
 * @method \App\Model\Entity\Visitaapontamento[] newEntities(array $data, array $options = [])
 * @method \App\Model\Entity\Visitaapontamento|bool save(\Cake\Datasource\EntityInterface $entity, $options = [])
 * @method \App\Model\Entity\Visitaapontamento patchEntity(\Cake\Datasource\EntityInterface $entity, array $data, array $options = [])
 * @method \App\Model\Entity\Visitaapontamento[] patchEntities($entities, array $data, array $options = [])
 * @method \App\Model\Entity\Visitaapontamento findOrCreate($search, callable $callback = null, $options = [])
 */
class VisitaapontamentoTable extends Table
{

    /**
     * Initialize method
     *
     * @param array $config The configuration for the Table.
     * @return void
     */
    public function initialize(array $config)
    {
        parent::initialize($config);

        $this->setTable('visitaapontamento');
        $this->setDisplayField('idvisitaapontamento');
        $this->setPrimaryKey('idvisitaapontamento');
    }

    /**
     * Default validation rules.
     *
     * @param \Cake\Validation\Validator $validator Validator instance.
     * @return \Cake\Validation\Validator
     */
    public function validationDefault(Validator $validator)
    {
        $validator
            ->integer('idvisitaapontamento')
            ->allowEmpty('idvisitaapontamento', 'create');

        $validator
            ->integer('idvisita')
            ->allowEmpty('idvisita');

        $validator
            ->integer('idusuario')
            ->allowEmpty('idusuario');

        $validator
            ->scalar('observacao')
            ->maxLength('observacao', 2000)
            ->allowEmpty('observacao');

        $validator
            ->dateTime('data_criacao')
            ->allowEmpty('data_criacao');

        $validator
            ->scalar('observacao_revisao')
            ->maxLength('observacao_revisao', 2000)
            ->allowEmpty('observacao_revisao');

        $validator
            ->dateTime('data_revisao')
            ->allowEmpty('data_revisao');

        $validator
            ->integer('idusuariorevisao')
            ->allowEmpty('idusuariorevisao');

        return $validator;
    }
}
