<?php

?>
<div class="row">
	<div class="col-md-12">
		<div class="card">
			<div class="card-header">
				<h5 class="card-title">Ajuda</h5>
			</div>
			<div class="card-body">
				Em caso de dúvidas, entre em contato através do email <a href="mailto:dev@flygestor.com.br">dev@flygestor.com.br</a>. Ficaremos felizes em ajudá-lo.
			</div>
		</div>
		<div class="card">
			<div class="card-header">
			<?= $this->Form->create($chamado) ?>
				<h5 class="card-title">Abrir Chamado</h5>
			</div>
			<div class="card-body">
				<label>Tipo</label>
				<select name="assunto2" class="form-control">
				  <option value="Suporte Técnico">Suporte Técnico</option>
				  <option value="Dúvida">Dúvida</option>
				  <option value="Melhoria">Melhoria</option>
				  <option value="Projeto">Projeto</option>
				  <option value="Crítica ou Elogio">Crítica ou Elogio</option>

				</select>
				<?php
            echo $this->Form->control('assunto',['class'=>'form-control']);
			echo "<label>Descrição</label>";
            echo $this->Form->textarea('descricao',['class'=>'form-control','label'=>'Descrição']);
		?>
		<br><br>
    <?= $this->Form->button(__('Enviar'),['class'=>'btn btn-primary']) ?>
    <?= $this->Form->end() ?>
			</div>
		</div>
		<div class="card">
			<div class="card-header"><h4>Chamados</h4></div>
			
	<table style="font-size:10px" class="table table-responsive table-striped datatable" cellpadding="0" cellspacing="0">
        <thead>
            <tr>
                <th scope="col">Cód.</th>
                <th scope="col">Assunto</th>
                <th scope="col">Status</th>
				<th scope="col">Data Prevista</th>
            </tr>
        </thead>
        <tbody>
            <?php foreach ($chamados as $chamado): ?>
            <tr style="cursor:pointer" onclick="window.open('ajuda/chamado/<?=$chamado->idchamado?>')">
                <td><?= $this->Number->format($chamado->idchamado) ?></td>
                <td><?= h($chamado->assunto) ?></td>
                <td><?php 
                    if(strlen($chamado->idchamadostatus) > 0){
                    	if($chamado->idchamadostatus == 5){
                    		echo "<span class='badge badge-success'>".$this->Custom->get('chamadostatus','idchamadostatus',$chamado->idchamadostatus)->descricao."</span>";
                    	} elseif($chamado->idchamadostatus == 3){
                    		echo "<span class='badge badge-primary'>".$this->Custom->get('chamadostatus','idchamadostatus',$chamado->idchamadostatus)->descricao."</span>";
                    	} elseif($chamado->idchamadostatus == 7){
                    		echo "<span class='badge badge-danger'>".$this->Custom->get('chamadostatus','idchamadostatus',$chamado->idchamadostatus)->descricao."</span>";
                    	} elseif($chamado->idchamadostatus == 6){
                    		echo "<span class='badge badge-secondary'>".$this->Custom->get('chamadostatus','idchamadostatus',$chamado->idchamadostatus)->descricao."</span>";
                    	} else{
                    		echo "<span class='badge badge-warning'>".$this->Custom->get('chamadostatus','idchamadostatus',$chamado->idchamadostatus)->descricao."</span>";
                    	}
                        
                    }
                ?></td>
                <td><?= $this->Custom->formatData($chamado->data_prevista) ?></td>
            </tr>
            <?php endforeach; ?>
        </tbody>
    </table>
		</div>
	</div>
</div>

<script>
setTimeout(function() { 
    $(".datatable").DataTable({
        "ordering": true,
        responsive: false,
        retrieve: false,
        paging : true,
        scroll : false,
        searching: true,
        fixedHeader: {
          header: true,
          footer: false
        },
        language: {
                url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                decimal: ",",
                thousands: "."
            },
            buttons: [
                {
                  extend: 'copy',
                  text: 'Copiar'
                },
                {
                  extend: 'print',
                  text: 'Imprimir',
                  messageTop: 'Relatório: ',
                },
                {
                  extend: 'excel',
                  text: 'Excel',
                  messageTop: 'Relatório:',
                },
                {
                  extend: 'pdf',
                  text: 'PDF',
                  messageTop: 'Relatório: ',
                }
            ],
            dom: 'Bfrtip'
    });
}, 500);
$('.datatable td').css('padding','3px');
</script>