<ul class="nav nav-tabs"  role="tablist">
	<li class="nav-item">
		<a class="nav-link active" onclick="" id="base-tab0" data-toggle="tab" aria-controls="dashboard" href="#dashboard" role="tab" aria-selected="false">Dashboard</a>
	</li>
	<li class="nav-item">
		<a class="nav-link" onclick="loadRelatorio()" id="base-tab1" data-toggle="tab" aria-controls="relatorios" href="#relatorios" role="tab" aria-selected="false">Relatórios</a>
	</li>
</ul>
<div class="tab-content">
	<div id="dashboard" class="tab-pane active">
        <div class="card">
            <div class="card-header">
                <h3>Módulo de Auditoria</h3>
            </div>
            <div class="card-body">
                <label>Filtrar os Pacientes Cadastrados:</label>
                <div class="row">
                    <div class="col-md-4">
                        <strong>Hospitais</strong>
                        <select id="hospital" onchange="reloadTable('hospital')" class="form-control">
                            <option value="todos">.: Selecione um Hospital :.</option>
                            <?php foreach ($hospitais as $item): ?>
                            <option value="<?=$item->hospitalid?>"><?=$item->nomefantasia?></option>
                            <?php endforeach; ?>
                        </select>
                    </div>
                    <div class="col-md-3">
                        <strong>Período</strong>
                        <div class='input-group'>
                            <input id="periodo" name="periodo" value="<?=Date("01/10/2020").' - '.Date("d/m/Y")?>" type='text' class="form-control shawCalRanges" />
                        </div>
                    </div>
                    <div class="col-md-3">
                        <strong>Local</strong>
                        <select id="local" onchange="reloadTable('hospital')" class="form-control">
                            <option value="todos">.: Selecione um Local :.</option>
                            <option value="UTI">UTI</option>
                            <option value="UCI">UCI</option>
                            <option value="Enfermaria">Enfermaria</option>
                            <option value="Isolamento Domiciliar">Isolamento Domiciliar</option>
                        </select>
                    </div>
                    <div class="col-md-2 mt-2">
                        <button class="btn btn-primary" type="button" onclick="reloadTable('hospital')">Filtrar</button>
                    </div>
                </div>
                <div id="arenacontentauditoria"></div>
            </div>
        </div>
    </div>
	<div id="relatorios" class="tab-pane">
        <div id="arenacontentrelatorios"></div>
    </div>
</div>

<script>
function reloadTable(tipo){
	let periodo = $('#periodo')[0].value.split('/').join('a')
    let hospital = $('#hospital')[0].selectedOptions[0].value
    let local = $('#local')[0].selectedOptions[0].value
    let url =  encodeURI("tabelaauditoria/"+hospital+"/"+tipo+"/"+local+"/"+periodo)
    $('#loading').show()
    $('#arenacontentauditoria').load("./auditoria/"+url,function(){
        $('#loading').hide()
    });
}

function loadRelatorio(){
    $('#loading').show()
    $('#arenacontentrelatorios').load("./auditoria/relatorios",function(){
        $('#loading').hide()
    });
}
$(document).ready(function () {
    reloadTable('hospital');
});

setTimeout(function() {
		var f = "DD/MM/Y";
		$('.shawCalRanges').daterangepicker({
			ranges: {
				'Hoje': [moment().format(f), moment().format(f)],
				'Ontem': [moment().subtract(1, 'days').format(f), moment().subtract(1, 'days').format(f)],
				'Últimos 7 dias': [moment().subtract(6, 'days').format(f), moment().format(f)],
				'Esse mês': [moment().startOf('month').format(f), moment().endOf('month').format(f)],
				'Mês passado': [moment().subtract(1, 'month').startOf('month').format(f), moment().subtract(1, 'month').endOf('month').format(f)],
				'Últimos 6 meses': [moment().subtract(6, 'month').startOf('month').format(f), moment().endOf('month').format(f)],
				'Esse ano': [moment().startOf('year').format(f), moment().endOf('year').format(f)],
				'Ano passado': [moment().subtract(1, 'year').startOf('year').format(f), moment().subtract(1, 'year').endOf('year').format(f)]
			},
			locale: {
				format: 'DD/MM/YYYY',
				applyLabel: "Ok",
				cancelLabel: 'Cancelar',
				startLabel: 'Início',
				endLabel: 'Fim',
				customRangeLabel: 'Período',
				daysOfWeek: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex','Sáb'],
				monthNames: ['Janeiro','Fevereiro','Março','Abril','Maio','Junho','Julho','Agosto','Setembro','Outubro','Novembro','Dezembro'],
				firstDay: 1
			},
			 alwaysShowCalendars: true,
		});
	}, 1000);
</script>