<?php
	$session = $this->request->session();
	$idperfil = $session->read('login.usuario')->idperfil;
	
	$mesMenos1 = (object)[
		'mes'=>$mesAtual-1
		,'ano'=>$anoAtual
	];
	$mesMenos2 = (object)[
		'mes'=>$mesAtual-2
		,'ano'=>$anoAtual
	];
	if($mesAtual == 1){
		$mesMenos1->mes = 12;
		$mesMenos1->ano = $anoAtual-1;
		
		$mesMenos2->mes = 11;
		$mesMenos2->ano = $anoAtual-1;
	}
	if($mesAtual == 2){
		$mesMenos1->mes = 1;
		$mesMenos1->ano = $anoAtual;
		
		$mesMenos2->mes = 12;
		$mesMenos2->ano = $anoAtual-1;
	}
?>

<div class="row">
	<div class="col-md-8">
		<h3>Títulos dos Beneficiários em <?=($mesAtual!=-1)?$this->Custom->toMes($mesAtual).'/':null?><?=$anoAtual?>
		</h3>
	</div>
	<div class="col-md-4">
		<form action="" method="POST" style="float:right" id="formmesano">
			<div class="input-group mb-1">
				<select name="mes" class="form-control" onchange="$('#loading').show();$('#formmesano').submit()">
					<option value="-1" <?=($mesAtual=="-1"?'selected':'')?>>.: TODOS :. </option>
					<option value="01" <?=($mesAtual=="01"?'selected':'')?>>Janeiro</option>
					<option value="02" <?=($mesAtual=="02"?'selected':'')?>>Fevereiro</option>
					<option value="03" <?=($mesAtual=="03"?'selected':'')?>>Março</option>
					<option value="04" <?=($mesAtual=="04"?'selected':'')?>>Abril</option>
					<option value="05" <?=($mesAtual=="05"?'selected':'')?>>Maio</option>
					<option value="06" <?=($mesAtual=="06"?'selected':'')?>>Junho</option>
					<option value="07" <?=($mesAtual=="07"?'selected':'')?>>Julho</option>
					<option value="08" <?=($mesAtual=="08"?'selected':'')?>>Agosto</option>
					<option value="09" <?=($mesAtual=="09"?'selected':'')?>>Setembro</option>
					<option value="10" <?=($mesAtual=="10"?'selected':'')?>>Outubro</option>
					<option value="11" <?=($mesAtual=="11"?'selected':'')?>>Novembro</option>
					<option value="12" <?=($mesAtual=="12"?'selected':'')?>>Dezembro</option>
				</select>
				<select name="ano" class="form-control" onchange="$('#loading').show();$('#formmesano').submit()">
					<?php for($i=0;$i<=20;$i++){ ?>
						<option value="<?=(date('Y')-$i)?>"   <?=($anoAtual==(date('Y')-$i)?   'selected':'')?>><?=(date('Y')-$i)?></option>
					<?php } ?>
				</select>
			</div>
		</form>
	</div>
</div>

<div class="card">
	<div class="card-content">
		<div class="row">
			<div class="col-lg-4 col-md-12 col-sm-12 border-right-blue-grey border-right-lighten-5">
				<div class="p-1 text-center">
					<div>
						<h3 class="display-6 blue-grey darken-1">
							Total<br>
							<?=$this->Custom->toMoney($resumotitulos->VALORTOTAL)?>
						</h3>
						<span class="blue-grey darken-1">
							de <b> <?=$this->Custom->toNumber($resumotitulos->TOTAL)?></b> título(s)
						</span>
					</div>
				</div>
			</div>
			<div class="col-lg-4 col-md-12 col-sm-12 border-right-blue-grey border-right-lighten-5">
				<div class="p-1 text-center">
					<div>
						<h3 class="display-6 success darken-1">
							Pagos<br>
							<?=$this->Custom->toPerc($resumotitulos->ATRASADO + $resumotitulos->EMDIA + $resumotitulos->ANTECIPADO,$resumotitulos->TOTAL)?><br>
							<?=$this->Custom->toMoney($resumotitulos->VALORATRASADO + $resumotitulos->VALOREMDIA + $resumotitulos->VALORANTECIPADO)?>
						</h3>
						<span class="blue-grey darken-1">
							de <b> <?=$this->Custom->toNumber($resumotitulos->ATRASADO + $resumotitulos->EMDIA + $resumotitulos->ANTECIPADO)?></b> título(s)
						</span>
					</div>
				</div>
			</div>
			<div class="col-lg-4 col-md-12 col-sm-12 border-right-blue-grey border-right-lighten-5">
				<div class="p-1 text-center">
					<div>
						<h3 class="display-6 danger darken-1">
							Não Pagos<br>
							<?=$this->Custom->toPerc($resumotitulos->ABERTO,$resumotitulos->TOTAL)?><br>
							<?=$this->Custom->toMoney($resumotitulos->VALORABERTO)?>
						</h3>
						<span class="blue-grey darken-1">
							de <b> <?=$this->Custom->toNumber($resumotitulos->ABERTO)?></b> título(s)
						</span>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>



<div class="row">
	<div class="col-xl-3 col-lg-6 col-12">
		<div class="card bg-gradient-directional-danger">
			<div class="card-content">
				<div class="card-body">
					<div class="media d-flex">
						<div class="media-body white text-left">
							<h3 style=" white-space: nowrap;"
								data-toggle="tooltip" 
								data-placement="top" 
								data-original-title="Títulos não pagos">
								Aberto</h3>
							<h3 style=" white-space: nowrap;"><?=$this->Custom->toPerc($resumotitulos->ABERTO,$resumotitulos->TOTAL)?></h3>
							<b style=" white-space: nowrap;">
								<?=$this->Html->link($this->Custom->toMoney($resumotitulos->VALORABERTO),
								"/adm/beneficiario/pessoatitulo/tipo=aberto"
								,['style'=>'color:white','data-toggle'=>"modal",'data-target'=>"#modal"])?>
							</b>
							<span>
								de <b><?=$this->Custom->toNumber($resumotitulos->ABERTO)?></b> título(s)
							</span>
						</div>
						<div class="align-self-center">
							<i class="fa fa-frown-o white font-large-2 float-right"></i>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="col-xl-3 col-lg-6 col-12">
		<div class="card bg-gradient-directional-warning">
			<div class="card-content">
				<div class="card-body">
					<div class="media d-flex">
						<div class="media-body white text-left">
							<h3 style=" white-space: nowrap;"
								data-toggle="tooltip" 
								data-placement="top" 
								data-original-title="Títulos pagos após a data de vencimento">
								Atrasado</h3>
							<h3 style=" white-space: nowrap;"><?=$this->Custom->toPerc($resumotitulos->ATRASADO,$resumotitulos->TOTAL)?></h3>
							<b style=" white-space: nowrap;">
								<?=$this->Html->link($this->Custom->toMoney($resumotitulos->VALORATRASADO),
								"/adm/beneficiario/pessoatitulo/tipo=atrasado"
								,['style'=>'color:white','data-toggle'=>"modal",'data-target'=>"#modal"])?>
							</b>
							<span>
								de <b><?=$this->Custom->toNumber($resumotitulos->ATRASADO)?></b> título(s)
							</span>
						</div>
						<div class="align-self-center">
							<i class="fa fa-meh-o white font-large-2 float-right"></i>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>

	<div class="col-xl-3 col-lg-6 col-12">
		<div class="card bg-gradient-directional-success">
			<div class="card-content">
				<div class="card-body">
					<div class="media d-flex">
						<div class="media-body white text-left">
							<h3 style=" white-space: nowrap;"
								data-toggle="tooltip" 
								data-placement="top" 
								data-original-title="Títulos pagos na data de vencimento">
								Em dia</h3>
							<h3 style=" white-space: nowrap;"><?=$this->Custom->toPerc($resumotitulos->EMDIA,$resumotitulos->TOTAL)?></h3>
							<b style=" white-space: nowrap;">
								<?=$this->Html->link($this->Custom->toMoney($resumotitulos->VALOREMDIA),
								"/adm/beneficiario/pessoatitulo/tipo=emdia"
								,['style'=>'color:white','data-toggle'=>"modal",'data-target'=>"#modal"])?>
							</b>
							<span>
								de <b><?=$this->Custom->toNumber($resumotitulos->EMDIA)?></b> título(s)
							</span>
						</div>
						<div class="align-self-center">
							<i class="fa fa-smile-o white font-large-2 float-right"></i>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="col-xl-3 col-lg-6 col-12">
		<div class="card bg-gradient-directional-primary">
			<div class="card-content">
				<div class="card-body">
					<div class="media d-flex">
						<div class="media-body white text-left">
							<h3 style=" white-space: nowrap;"
								data-toggle="tooltip" 
								data-placement="top" 
								data-original-title="Títulos pagos antes da data de vencimento">
								Antecipado</h3>
							<h3 style=" white-space: nowrap;"><?=$this->Custom->toPerc($resumotitulos->ANTECIPADO,$resumotitulos->TOTAL)?></h3>
							<b style=" white-space: nowrap;">
								<?=$this->Html->link($this->Custom->toMoney($resumotitulos->VALORANTECIPADO),
								"/adm/beneficiario/pessoatitulo/tipo=antecipado"
								,['style'=>'color:white','data-toggle'=>"modal",'data-target'=>"#modal"])?>
							</b>
							<span>
								de <b><?=$this->Custom->toNumber($resumotitulos->ANTECIPADO)?></b> título(s)
							</span>
						</div>
						<div class="align-self-center">
							<i class="fa fa-smile-o white font-large-2 float-right"></i>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>


<div class="row">
	<div class="col-md-8">
		<h3>Beneficiários
		</h3>
	</div>

</div>

<div class="row">
	<div class="col-md-6">
		<div class="card">
			<div class="card-content">
				<div class="p-1 text-center">
					<h3 class="display-6 success darken-1">Ativos</h3>
				</div>
				<div id="pizzapfpj" class="height-200 echart-container" ></div>
				<div class="row text-center">
					<div class="col-md-6">
						<h3 class="display-6 success darken-1">Pessoa Física</h3>
						<h2><?=$this->Custom->toNumber($resumoativos2->TOTAL)?></h2>
					</div>
					<div class="col-md-6">
						<h3 class="display-6 success darken-1">Pessoa Jurídica</h3>
						<h2><?=$this->Custom->toNumber($resumoativospj->TOTAL)?></h2>
					</div>
				</div>
			</div>
		</div>
	</div>
	
	<div class="col-md-6">
		<div class="card">
			<div class="card-content text-center">
				<br>
				<h3 class="display-6 primary darken-1"><?=$this->Custom->toMes($mesAtual)?>/<?=$anoAtual?></h3>
					<div class="row">
						<div class="col-md-6">
							<h3 class="display-6 success darken-1">Ativados</h3>
							<h2><?=$this->Custom->toNumber($resumoativos->ATIVOSMES)?></h2>
						</div>
						<div class="col-md-6">
							<h3 class="display-6 danger darken-1">Inativados</h3>
							<h2><?=$this->Custom->toNumber($resumoativos->INATIVOSMES)?></h2>
						</div>
					</div>
					<hr>
					<div class="row">
						<div class="col-md-12">
							<h3 class="display-6 primary darken-1">CHURN</h3>
						</div>
					</div>
					<div class="row">
						<div class="col-md-6">
							<h3 class="display-6 success darken-1"><?=$this->Custom->toMes($mesAtual,true)?>/<?=$anoAtual?></h3>
							<h2>
							<?php if($resumoativos->ATIVOSMES >= $resumoativos->INATIVOSMES){ ?>
								<?=$this->Custom->toPerc($resumoativos->INATIVOSMES,$resumoativos->ATIVOSMES)?>
							<?php }else{ ?>
								 - <?=$this->Custom->toPerc($resumoativos->INATIVOSMES,$resumoativos->ATIVOSMES)?>
							<?php } ?>
							</h2>
							Entradas: <b><?=$this->Custom->toNumber($resumoativos->ATIVOSMES)?></b>
							<br>
							Saídas: <b><?=$this->Custom->toNumber($resumoativos->INATIVOSMES)?></b>
							<br>
							Diferença: <b><?=$this->Custom->toNumber($resumoativos->ATIVOSMES-$resumoativos->INATIVOSMES)?></b>
						</div>
						<div class="col-md-6">
							<h3 class="display-6 danger darken-1"><?=$anoAtual?></h3>
							<h2>
							<?php if($resumoativos->ATIVOSANO >= $resumoativos->INATIVOSANO){ ?>
								<?=$this->Custom->toPerc($resumoativos->INATIVOSANO,$resumoativos->ATIVOSANO)?>
							<?php }else{ ?>
								 - <?=$this->Custom->toPerc($resumoativos->INATIVOSANO,$resumoativos->ATIVOSANO)?>
							<?php } ?>
							</h2>
							Entradas: <b><?=$this->Custom->toNumber($resumoativos->ATIVOSANO)?></b>
							<br>
							Saídas: <b><?=$this->Custom->toNumber($resumoativos->INATIVOSANO)?></b>
							<br>
							Diferença: <b><?=$this->Custom->toNumber($resumoativos->ATIVOSANO-$resumoativos->INATIVOSANO)?></b>
						</div>
					</div>
					<br>
				</div>
			</div>
		</div>	
	</div>
</div>


<div class="row">
	<div class="col-md-12">
		<div class="card">
			<div class="card-content">
				<div class="p-1 text-center">
					<h3 class="display-6 primary darken-1">Entrada de Beneficiários por Ano</h3>
				</div>
				<div id="linhaativoano" class="height-300 echart-container" ></div>
			</div>
		</div>
	</div>
</div>

<div class="card">
	<div class="card-body">
		<div class="row">
			<div class="col-xl-3 col-lg-6 col-12 border-right-blue-grey border-right-lighten-5">
				<div class="pb-1">
					<div class="clearfix mb-1">
						<span class="font-large-1 text-bold-300 warning float-left"> <?=$anoAtual?> </span>
					</div>
					<div class="clearfix">
						<span class="text-muted">
						<h3>Total <?=$this->Custom->toNumber($totalAnoAtual)?></h3>
									média mensal
							<b style=" white-space: nowrap;">
								<?=$this->Custom->toFloat($mediaAnoAtual)?>
							</b><br>
							<?php if($totalAnoAtual > $totalAnoMenos1){ ?>
								crescimento de
								<b style=" white-space: nowrap;">
									<?=$this->Custom->toFloat((1-($totalAnoMenos1/$totalAnoAtual))*100)?>%
								</b>
							<?php }else{ ?>
								retração de
								<b style=" white-space: nowrap;">
									<?=$this->Custom->toFloat((1-($totalAnoAtual/$totalAnoMenos1))*100)?>%
								</b>
							<?php } ?> </span>
					</div>
				</div>
			</div>
			<div class="col-xl-3 col-lg-6 col-12 border-right-blue-grey border-right-lighten-5">
				<div class="pb-1">
					<div class="clearfix mb-1">
						<span class="font-large-1 text-bold-300 success float-left"> <?=$anoAtual-1?></span>
					</div>
					<div class="clearfix">
						<span class="text-muted"><h3>Total <?=$this->Custom->toNumber($totalAnoMenos1)?></h3>
							média mensal 
							<b style=" white-space: nowrap;">
								<?=$this->Custom->toFloat($mediaAnoMenos1)?>
							</b><br>
							<?php if($totalAnoMenos1 > $totalAnoMenos2){ ?>
								crescimento de
								<b style=" white-space: nowrap;">
									<?=$this->Custom->toFloat((1-($totalAnoMenos2/$totalAnoMenos1))*100)?>%
								</b>
							<?php }else{ ?>
								retração de
								<b style=" white-space: nowrap;">
								<?=$this->Custom->toFloat((1-($totalAnoMenos1/$totalAnoMenos2))*100)?>%
								</b>
							<?php } ?></span>
					</div>
				</div>
			</div>
			<div class="col-xl-3 col-lg-6 col-12 border-right-blue-grey border-right-lighten-5">
				<div class="pb-1">
					<div class="clearfix mb-1">
						<span class="font-large-1 text-bold-300 info float-left"> <?=$anoAtual-2?></span>
					</div>
					<div class="clearfix">
						<span class="text-muted"><h3>Total <?=$this->Custom->toNumber($totalAnoMenos2)?></h3>
							média mensal 
							<b style=" white-space: nowrap;">
								<?=$this->Custom->toFloat($mediaAnoMenos2)?>
							</b></span>
					</div>
				</div>
			</div>
			<div class="col-xl-3 col-lg-6 col-12 border-right-blue-grey border-right-lighten-5">
				<div class="pb-1">
					<div class="clearfix mb-1">
						<span class="font-large-1 text-bold-300 info float-left"> Média</span>
					</div>
					<div class="clearfix">
						<span class="text-muted">
							<h3><?=$this->Custom->toFloat($mediaporano[0]*12)?></h3>
							média mensal 
							<b style=" white-space: nowrap;">
								<?=$this->Custom->toFloat($mediaporano[0])?>
							</b></span>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>

<h3>Produtos</h3>

<div class="card">
	<div class="card-content">
		<div class="row">
			<div class="col-md-12">
				<br>
				<table class="table table-striped table-responsive datatable" cellspacing="0" cellpadding="0">
					<thead>
						<tr>
							<th>Produto</th>
							<th>Qtd Benef.</th>
							<th>Masculino</th>
							<th style="text-align:center">%</th>
							<th>Feminino</th>
							<th style="text-align:center">%</th>
							<th>Média Idade</th>
						</tr>
					</thead>
					<tbody>
						<?php foreach($resumoprodutos as $item){ ?>
						<tr>
							<td><?=$item->PRODUTO?></td>
							<td><?=$this->Custom->toNumber($item->BENEFICIARIOS)?></td>
							<td><?=$this->Custom->toNumber($item->MASCULINO)?></td>
							<td><?=$this->Custom->toFloat($item->MASCULINO*100/(($item->BENEFICIARIOS == 0) ? 1 : $item->BENEFICIARIOS) )?></td>
							<td><?=$this->Custom->toNumber($item->FEMININO)?></td>
							<td><?=$this->Custom->toFloat($item->FEMININO*100/(($item->BENEFICIARIOS == 0) ? 1 : $item->BENEFICIARIOS) )?></td>
							<td><?=$this->Custom->toFloat($item->ANOS/$item->BENEFICIARIOS)?></td>
						</tr>
						<?php } ?>
					</tbody>
				</table>
			</div>
		</div>
	</div>
</div>

<script>



setTimeout(function() { 
	pizza('pizzapfpj',{label:['Pessoa Física','Pessoa Jurídica'],value:[<?=$resumoativos->TOTAL?>,<?=$resumoativospj->TOTAL?>]},'Beneficiários');
	linha3('linhaativoano', <?=$jsonlinhaativosporano?>);
}, 200);



function pizza (id,json,label) {
	var data = [];
	var valueOutros = 0;
	for(i = 0; i < json.label.length; i++){
		if(i < 6){
			var name = json.label[i];
			if(!name){
				name = '(sem nome)';
			}
			if(name.length > 20){
				name = name.substring(0,19);
			}
			data[i] = {name: name, value: json.value[i]};
		}else{
			valueOutros = valueOutros + json.value[i];
			data[6] = {name: 'Outros', value: valueOutros};
		}
		
	}
	// Initialize chart
	// ------------------------------
	var myChart = echarts.init(document.getElementById(id));

	// Chart Options
	// ------------------------------
	chartOptions = {
		// Add tooltip
		tooltip: {
			trigger: 'item',
			formatter: "{a} <br/>{b}: {d}%"
		},

		// Add legend
		legend: {
			orient: 'horizontal',
			x: 'left',
			data: data
		},

		// Enable drag recalculate
		calculable: true,

		// Add series
		series: [{
			name: label,
			type: 'pie',
			radius: ['50%', '70%'],
			avoidLabelOverlap: false,
			label: {
                normal: {
                    normal: {
                    show: false,
                    position: 'center'
                },
                emphasis: {
                    show: true,
                    textStyle: {
                        fontSize: '30',
                        fontWeight: 'bold'
                    }
                }
                }
            },
			labelLine: {
                normal: {
                    show: false
                }
            },
			data: data
		}]
	};

	// Apply options
	// ------------------------------

	myChart.setOption(chartOptions);


	// Resize chart
	// ------------------------------

	$(function () {

		// Resize chart on menu width change and window resize
		$(window).on('resize', resize);
		$(".menu-toggle").on('click', resize);

		// Resize function
		function resize() {
			setTimeout(function() {

				// Resize chart
				myChart.resize();
			}, 200);
		}
	});
}



function linha3(iddiv, json) {
	var myChart = echarts.init(document.getElementById(iddiv));
	// Chart Options
	// ------------------------------
	chartOptions = {

		// Setup grid
		grid: {
			x: 60,
			x2: 40,
			y: 45,
			y2: 25
		},

		// Add Tooltip
		tooltip : {
			trigger: 'axis'
		},

		// Add Legend
		legend: {
			data:['<?=$anoAtual?>', '<?=$anoAtual-1?>','<?=$anoAtual-2?>','Média']
		},

		// Add custom colors
		color: ['#F98E76', '#16D39A', '#2DCEE3','#000000'],

		// Enable drag recalculate
		calculable : true,

		// Horizontal Axiz
		xAxis : [
			{
				name : 'Tabela',
				nameLocation : 'center',
				nameGap : 5,
				type : 'category',
				boundaryGap : false,
				data : ['Jan','Fev','Mar','Abr','Mai','Jun','Jul','Ago','Set','Out','Nov','Dez']
			}
		],

		// Vertical Axis
		yAxis : [
			{
				name : 'Beneficiários',				
				type : 'value',
				axisLabel : {
					formatter: '{value}',
				},
				nameGap:0
			}
		],

		// Add Series
		series : [
			{
				name:'<?=$anoAtual?>',
				type:'line',
				data:json.ANOATUAL
			},
			{
				name:'<?=$anoAtual-1?>',
				type:'line',
				data:json.ANOMENOS1
			},
			{
				name:'<?=$anoAtual-2?>',
				type:'line',
				data:json.ANOMENOS2
			},
			{
				name:'Média',
				type:'line',
				data:json.MEDIA
			},
		]
	};

	// Apply options
	// ------------------------------

	myChart.setOption(chartOptions);


	// Resize chart
	// ------------------------------

	$(function () {

		// Resize chart on menu width change and window resize
		$(window).on('resize', resize);
		$(".menu-toggle").on('click', resize);

		// Resize function
		function resize() {
			setTimeout(function() {

				// Resize chart
				myChart.resize();
			}, 200);
		}
	});
}

</script>
<script>
$(document).ready(
        function() {
            $('.datatable').DataTable( 
            {
                language: {
                    url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                    decimal: ",",
                    thousands: "."
                },
                dom: 'Bfrtip',
                buttons: [
                {
                    extend: 'copy',
                    text: 'Copiar',
                    footer: true
                },
                {
                    extend: 'print',
                    text: 'Imprimir',
                    footer: true
                },
                {
                    extend: 'excel',
                    filename: 'FlyMed',
                    text: 'Excel',
                    footer: true
                },
                {
                    extend: 'pdf',
            //Name the pdf
            filename: 'FlyMed ',
            text: 'PDF',
            orientation:'portrait',
            title:'FlyMed ',
            pageSize:'A2',
            footer: true
            }
            ],
            responsive: false,
            retrieve: false,
            paging : true,
            "pageLength":10,
            "order": [[ 1, "desc" ]],
            "scrollX" : true,
            fixedHeader: {
                header: false,
                footer: false
            },
			"initComplete": function() {
				window.dispatchEvent(new Event('resize'));
  			}
            } 
            );}
        );

</script>