<?php 
    $session = $this->request->session();
    $empresa = $session->read('login.empresa')->nome;
?>
<div class="card-body">
    <ul class="nav nav-tabs nav-top-border no-hover-bg nav-justified">
        <li class="nav-item">
            <a class="nav-link active" onclick="setTimeout(function () { window.dispatchEvent(new Event('resize'));},250)" id="resumolink" data-toggle="tab" href="#resumo" aria-controls="resumo" aria-expanded="true">
                Resumo Simplificado
            </a>
        </li>
        <li class="nav-item">
            <a class="nav-link disabled" id="detalhadolink" onclick="setTimeout(function () { window.dispatchEvent(new Event('resize'));},250)" data-toggle="tab" href="#detalhado" aria-controls="detalhado" aria-expanded="true">
                Resumo Detalhado
            </a>
        </li>
    </ul>
    <div class="tab-content px-1 pt-1" style="width:100%">
        <div role="tabpanel" class="tab-pane active" id="resumo" aria-labelledby="resumo" aria-expanded="true">   
            <div class="row">
                <div class="card col-xl-12 col-lg-12 col-md-12">
                    <div class="card-header">
                        <h3>Relação de Títulos <?=$condicao2?></h3>
                <?php if ($condicao != 'emdia') { ?><h4> Média de dias <?=$condicao2?>: <?=$this->Custom->toFloat($media)?></h4><?php }?>
                    </div>
                    <table class="table table-striped datatable" id="datatable">
                        <thead>
                            <tr>
                                <th>Número do Documento</th>
                                <th>Valor <br> (R$)</th>
                                <th>Total Pago <br> (R$)</th>
                                <th>Diff Pagamento <br> (R$)</th>
            <?php if($condicao != 'aberto'){ ?><th>Média Pagamentos <br> (R$)</th>
                                <th>Data Pagamento</th> <?php } ?>
                                <th>Vencimento</th>
                                <?php if($condicao != 'emdia') { ?> <th>Dias <?=$condicao2?></th> <?php } ?>
                            </tr>
                        </thead>
                        <tbody>
                            <?php foreach ($resumo as $item): ?>
                                <tr style="cursor:pointer" onclick="detalhar('<?=$item->NUM_DOC?>')">
                                    <td><?=$item->NUM_DOC?></td>
                                    <td><?=$this->Custom->toFloat($item->VALOR_TOTAL)?></td>
                                    <td><?=($item->VALOR_PAGO == null) ? '0.00' : $this->Custom->toFloat($item->VALOR_PAGO)?></td>
                                    <td><?=$this->Custom->toFloat($item->VALOR_TOTAL-$item->VALOR_PAGO)?></td>
                                    <?php if($condicao != 'aberto'){ ?>
                                    <td><?=$this->Custom->toFloat($mediapag)?></td>
                                    <td><?=$item->DATA_PGTO?></td> <?php } ?>
                                    <td><?=$item->DATA_VENCIMENTO?></td>
                            <?php if($condicao != 'emdia') { ?> <td><?=$this->Custom->toNumber($item->DIAS)?></td> <?php } ?>
                                </tr>
                            <?php endforeach; ?>
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>Total</th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                            <?php if($condicao != 'aberto'){ ?> <th></th>
                                <th></th> <?php } ?>
                            <?php if($condicao != 'emdia') { ?> <th></th> <?php } ?>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>
        </div>
        <div role="tabpanel" class="tab-pane" id="detalhado" aria-labelledby="detalhado" aria-expanded="true">   
            <div class="row">
                <div class="card col-xl-12 col-lg-12 col-md-12">
                    <div class="card-header">
                        <h3>Relação de Títulos <?=$condicao2?></h3>
                <?php if ($condicao != 'emdia') { ?><h4> Média de dias <?=$condicao2?>: <?=$this->Custom->toFloat($media)?></h4><?php }?>
                    </div>
                    <table class="table table-striped datatable" id="datatable4">
                        <thead>
                            <tr>
                                <th>Número do Documento</th>
                                <th>Tipo Doc.</th>
                                <th>Cód. Beneficiario</th>
                                <th>Cód. Família</th>
                                <th>Cód. Contrato</th>
                                <th>Verba</th>
                                <th>Valor <br> (R$)</th>
                            </tr>
                        </thead>
                        <tbody id="tablebody">
                        </tbody>
                        <tfoot>
                            <tr>
                                <th>Total</th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                                <th></th>
                            </tr>
                        </tfoot>
                    </table>
                </div>
            </div>            
        </div>  
	</div>
</div>

<script>
    function detalhar(num_doc){
        document.getElementById('detalhado').setAttribute("class", "tab-pane active");
        document.getElementById('resumo').setAttribute("class", "tab-pane fade");
        document.getElementById('resumolink').setAttribute("class", "nav-link");
        document.getElementById('detalhadolink').setAttribute("class", "nav-link active");
        var urlnumdoc = '../pessoaresumotitulo/'+num_doc;
	    var tablebody = document.getElementById("tablebody");
        var t = $('#datatable4').DataTable();
        t.clear().draw();
		$.ajax({ type: "GET",   
			url: urlnumdoc,
			async: false,
			success : function(text)
			{
				response = text;
				if(jQuery.isEmptyObject(response)){
					alert("Houve um erro durante a consulta ao banco de dados."); 
				} else {
					for(var i = 0; i<response['resumo'].length; i++){	
                        t.row.add([
                            response['resumo'][i]['NUM_DOC'],
                            response['resumo'][i]['DESC_TIPO_DOC'],
                            response['resumo'][i]['COD_BENEFICIARIO'],
                            response['resumo'][i]['COD_FAMILIA'],
                            response['resumo'][i]['COD_CONTRATO'],
                            response['resumo'][i]['DESC_VERBA'],
                            parseFloat(response['resumo'][i]['VALOR_CC']).toLocaleString(undefined, {minimumFractionDigits: 2, maximumFractionDigits: 2})]
                        ).draw(true);
					}	
				}
			},
			error: function() { 
				alert("Houve um erro durante a consulta ao banco de dados."); 
			} 
	}).responseText;	
        
        setTimeout(function () { window.dispatchEvent(new Event('resize'));},250);
        //var table = $('#datatable4').DataTable();
        //table.search(num_doc).draw();
    }
</script>

<script>
    $(document).ready(
        function() {
            $('#datatable').DataTable( 
            {
                language: {
                    url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                    decimal: ",",
                    thousands: "."
                },
                dom: 'Bfrtip',
                buttons: [
                {
                    extend: 'copy',
                    text: 'Copiar',
                    footer: true
                },
                {
                    extend: 'print',
                    text: 'Imprimir',
                    footer: true
                },
                {
                    extend: 'excel',
                    filename: 'FlyMed',
                    text: 'Excel',
                    footer: true
                },
                {
                    extend: 'pdf',
            //Name the pdf
            filename: 'FlyMed Relação de Títulos em <?=$condicao2?> - <?=$empresa?>',
            text: 'PDF',
            orientation:'portrait',
            title:'FlyMed Relação de Títulos em <?=$condicao2?> - <?=$empresa?>',
            pageSize:'A2',
            footer: true
            }
            ],
            responsive: false,
            fixedColumns:{
                leftColumns:1
            },
            retrieve: false,
            paging : true,
            "pageLength":10,
            "order": [[ 1, "desc" ]],
            "scrollX" : true,
            fixedHeader: {
                header: false,
                footer: false
            },
            "footerCallback": function ( row, data, start, end, display ) {
                var totalcolums = [1,2,3];

                var api = this.api(), data;
                // Remove the formatting to get integer data for summation
                var intVal = function (i) {
                    if(typeof i === 'string'){
                        i = i.toString();
                        i = i.replace('<span style=\"color:red\">', '');
                        i = i.replace('</span>', '');
                    }

                    return typeof i === 'string' ?
                    i.replace(/\./g, '').replace(/\,/g, '.') * 1 :
                    typeof i === 'number' ?
                    i : 0;
                };

                for(i=0;i<totalcolums.length;i++){
                    var col = api .column( totalcolums[i], {filter:'applied'} ).data().reduce( function (a, b) {return intVal(a) + intVal(b);}, 0 );
                    col = col.toLocaleString('pt-BR', {minimumFractionDigits: 2, maximumFractionDigits: 2});
                    col = col < 0 ? '<span style=\"color:red\">'+col+'</span>' : col;
                    $( api.column( totalcolums[i] ).footer() ).html(col);
                }
            },
			"initComplete": function() {
				window.dispatchEvent(new Event('resize'));
  			}

            } 
            );
            $('#datatable4').DataTable( 
            {
                language: {
                    url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                    decimal: ",",
                    thousands: "."
                },
                dom: 'Bfrtip',
                buttons: [
                {
                    extend: 'copy',
                    text: 'Copiar',
                    footer: true
                },
                {
                    extend: 'print',
                    text: 'Imprimir',
                    footer: true
                },
                {
                    extend: 'excel',
                    filename: 'FlyMed',
                    text: 'Excel',
                    footer: true
                },
                {
                    extend: 'pdf',
            //Name the pdf
            filename: 'FlyMed Relação Detalhada de Títulos em <?=$condicao2?> - <?=$empresa?>',
            text: 'PDF',
            orientation:'portrait',
            title:'FlyMed Relação Detalhada de Títulos em <?=$condicao2?> - <?=$empresa?>',
            pageSize:'A2',
            footer: true
            }
            ],
            responsive: false,
            fixedColumns:{
                leftColumns:1
            },
            retrieve: false,
            paging : true,
            "pageLength":10,
            "order": [[ 1, "desc" ]],
            "scrollX" : true,
            fixedHeader: {
                header: false,
                footer: false
            },
            "footerCallback": function ( row, data, start, end, display ) {
                var totalcolums = [6];

                var api = this.api(), data;
                // Remove the formatting to get integer data for summation
                var intVal = function (i) {
                    if(typeof i === 'string'){
                        i = i.toString();
                        i = i.replace('<span style=\"color:red\">', '');
                        i = i.replace('</span>', '');
                    }

                    return typeof i === 'string' ?
                    i.replace(/\./g, '').replace(/\,/g, '.') * 1 :
                    typeof i === 'number' ?
                    i : 0;
                };

                for(i=0;i<totalcolums.length;i++){
                    var col = api .column( totalcolums[i], {filter:'applied'} ).data().reduce( function (a, b) {return intVal(a) + intVal(b);}, 0 );
                    col = col.toLocaleString('pt-BR', {minimumFractionDigits: 2, maximumFractionDigits: 2});
                    col = col < 0 ? '<span style=\"color:red\">'+col+'</span>' : col;
                    $( api.column( totalcolums[i] ).footer() ).html(col);
                }
            },
			"initComplete": function() {
				window.dispatchEvent(new Event('resize'));
                $('#datatable').DataTable().draw();
  			}

            } 
            );}
        )
    </script>