<div class="card">
    <div class="card-body">      
        <strong><?=$title?></strong>
        <table class="table datatable table-responsive table-stripped mb-2" id="datatableempresasagrupado">
            <thead>
                <th>Nome</th>
                <th>CNPJ</th>
                <th>Dias Atraso</th>
                <th>Valor Total</th>
                <th>Valor Pago</th>
            </thead>
            <tbody>
                <?php foreach ($contasempresaagrupado as $item): ?>
                <tr>
                    <td><nobr><?=$item->nome_fantasia?></nobr></td>
                    <td><?=$item->cgc_empresa?></td>
                    <td><?=($item->diasatraso < 0) ? 0 : $item->diasatraso?></td>
                    <td><?=$this->Custom->toFloat($item->valor_faturado)?></td>
                    <td><?=$this->Custom->toFloat($item->recebido)?></td>
                </tr>
                <?php endforeach;?>
            </tbody>
            <tfoot>
                <th>Total:</th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
            </tfoot>
        </table>    
        <strong><?=$title2?></strong>    
        <table class="table datatable table-responsive table-stripped" id="datatableempresas">
            <thead>
                <th>Nome</th>
                <th>CNPJ</th>
                <th>Vencimento</th>
                <th>Baixa</th>
                <th>Dias Atraso</th>
                <th>Valor Total</th>
                <th>Valor Pago</th>
                <th>Número Documento</th>
                <th>Local Pagamento</th>
            </thead>
            <tbody>
                <?php foreach ($contasempresa as $item): ?>
                <tr>
                    <td><nobr><?=$item->nome_fantasia?></nobr></td>
                    <td><?=$item->cgc_empresa?></td>
                    <td><?=$this->Custom->formatData($item->data_vencimento)?></td>
                    <td><?=$this->Custom->formatData($item->data_recebimento)?></td>
                    <td><?=($item->diasatraso < 0) ? 0 : $item->diasatraso?></td>
                    <td><?=$this->Custom->toFloat($item->valor_faturado)?></td>
                    <td><?=$this->Custom->toFloat($item->recebido)?></td>
                    <td><?=$item->numero_fatura?></td>
                    <td><?=$item->desc_local_pgto?></td>
                </tr>
                <?php endforeach;?>
            </tbody>
            <tfoot>
                <th>Total:</th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
                <th></th>
            </tfoot>
        </table>
    </div>
</div>

<script>
function tabelaempresamodal() {
    $('#datatableempresas').DataTable( 
        {
            language: {
                url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                decimal: ",",
                thousands: "."
            },
            dom: 'Bfrtip',
            destroy: true,
            buttons: [],
            responsive: false,
            retrieve: false,
            paging : true,
            "order":[[4,"desc"]],
            "footerCallback": function ( row, data, start, end, display ) {
                var totalcolums = [4,5];

                var api = this.api(), data;
                // Remove the formatting to get integer data for summation
                var intVal = function (i) {
                    if(typeof i === 'string'){
                        i = i.toString();
                        i = i.replace('<span style=\"color:red\">', '');
                        i = i.replace('</span>', '');
                    }

                    return typeof i === 'string' ?
                    i.replace(/\./g, '').replace(/\,/g, '.') * 1 :
                    typeof i === 'number' ?
                    i : 0;
                };

                for(i=0;i<totalcolums.length;i++){
                    var col = api .column( totalcolums[i], {filter:'applied'} ).data().reduce( function (a, b) {return intVal(a) + intVal(b);}, 0 );
                    col = col.toLocaleString('pt-BR');
                    col = col < 0 ? '<span style=\"color:red\">'+col+'</span>' : col;
                    $( api.column( totalcolums[i] ).footer() ).html(col);
                }
            },
            "pageLength":10,
            "scrollX" : false,
            fixedHeader: {
                header: false,
                footer: false
            },
            "initComplete": function() {
                window.dispatchEvent(new Event('resize'));
            }
        } 
    );
    $('#datatableempresasagrupado').DataTable( 
        {
            language: {
                url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                decimal: ",",
                thousands: "."
            },
            dom: 'Bfrtip',
            destroy: true,
            buttons: [],
            responsive: false,
            retrieve: false,
            paging : true,
            "order":[[2,"desc"]],
            "footerCallback": function ( row, data, start, end, display ) {
                var totalcolums = [3,4];

                var api = this.api(), data;
                // Remove the formatting to get integer data for summation
                var intVal = function (i) {
                    if(typeof i === 'string'){
                        i = i.toString();
                        i = i.replace('<span style=\"color:red\">', '');
                        i = i.replace('</span>', '');
                    }

                    return typeof i === 'string' ?
                    i.replace(/\./g, '').replace(/\,/g, '.') * 1 :
                    typeof i === 'number' ?
                    i : 0;
                };

                for(i=0;i<totalcolums.length;i++){
                    var col = api .column( totalcolums[i], {filter:'applied'} ).data().reduce( function (a, b) {return intVal(a) + intVal(b);}, 0 );
                    col = col.toLocaleString('pt-BR');
                    col = col < 0 ? '<span style=\"color:red\">'+col+'</span>' : col;
                    $( api.column( totalcolums[i] ).footer() ).html(col);
                }
            },
            "pageLength":10,
            "scrollX" : false,
            fixedHeader: {
                header: false,
                footer: false
            },
            "initComplete": function() {
                window.dispatchEvent(new Event('resize'));
            }
        } 
    );
}
$(document).ready(function () {tabelaempresamodal()});

$('#datatableempresas').DataTable( 
        {
            language: {
                url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                decimal: ",",
                thousands: "."
            },
            dom: 'Bfrtip',
            destroy: true,
            buttons: [],
            "order":[[4,"desc"]],
            responsive: false,
            retrieve: false,
            paging : true,
            "footerCallback": function ( row, data, start, end, display ) {
                var totalcolums = [4,5];

                var api = this.api(), data;
                // Remove the formatting to get integer data for summation
                var intVal = function (i) {
                    if(typeof i === 'string'){
                        i = i.toString();
                        i = i.replace('<span style=\"color:red\">', '');
                        i = i.replace('</span>', '');
                    }

                    return typeof i === 'string' ?
                    i.replace(/\./g, '').replace(/\,/g, '.') * 1 :
                    typeof i === 'number' ?
                    i : 0;
                };

                for(i=0;i<totalcolums.length;i++){
                    var col = api .column( totalcolums[i], {filter:'applied'} ).data().reduce( function (a, b) {return intVal(a) + intVal(b);}, 0 );
                    col = col.toLocaleString('pt-BR');
                    col = col < 0 ? '<span style=\"color:red\">'+col+'</span>' : col;
                    $( api.column( totalcolums[i] ).footer() ).html(col);
                }
            },
            "pageLength":10,
            "scrollX" : false,
            fixedHeader: {
                header: false,
                footer: false
            },
            "initComplete": function() {
                window.dispatchEvent(new Event('resize'));
            }
        } 
    );
    
    $('#datatableempresasagrupado').DataTable( 
        {
            language: {
                url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                decimal: ",",
                thousands: "."
            },
            dom: 'Bfrtip',
            destroy: true,
            buttons: [],
            responsive: false,
            retrieve: false,
            paging : true,
            "order":[[2,"desc"]],
            "footerCallback": function ( row, data, start, end, display ) {
                var totalcolums = [3,4];

                var api = this.api(), data;
                // Remove the formatting to get integer data for summation
                var intVal = function (i) {
                    if(typeof i === 'string'){
                        i = i.toString();
                        i = i.replace('<span style=\"color:red\">', '');
                        i = i.replace('</span>', '');
                    }

                    return typeof i === 'string' ?
                    i.replace(/\./g, '').replace(/\,/g, '.') * 1 :
                    typeof i === 'number' ?
                    i : 0;
                };

                for(i=0;i<totalcolums.length;i++){
                    var col = api .column( totalcolums[i], {filter:'applied'} ).data().reduce( function (a, b) {return intVal(a) + intVal(b);}, 0 );
                    col = col.toLocaleString('pt-BR');
                    col = col < 0 ? '<span style=\"color:red\">'+col+'</span>' : col;
                    $( api.column( totalcolums[i] ).footer() ).html(col);
                }
            },
            "pageLength":10,
            "scrollX" : false,
            fixedHeader: {
                header: false,
                footer: false
            },
            "initComplete": function() {
                window.dispatchEvent(new Event('resize'));
            }
        } 
    );
</script>