
<div class="card">
    <div class="card-header">
        <h3>Empresas Pertencentes ao Setor de Atividade: <?=$setor_atividade?></h3>
    </div>
    <div class="card-body">
		<div class="row">
            <div class="col-md-3">
                <div class="w3-card w3-hover-shadow w3-center" style="height:100px"><br>
                    <h3 style="color:#000000"><b><?=$this->Custom->toNumber($qtd_empresas)?></b></h3>    
                    <h4 style="color:#000000">Empresas</h4>
                </div>
            </div>
            <div class="col-md-3">
                <div class="w3-card w3-hover-shadow w3-center" style="height:100px"><br>
                    <h3 style="color:#000000"><b><?=$this->Custom->toNumber($qtd_individuos)?></b></h3>    
                    <h4 style="color:#000000">Indivíduos</h4>
                </div>
            </div>
            <div class="col-md-3">
                <div class="w3-card w3-hover-shadow w3-center" style="height:100px"><br>
                    <h3 style="color:#16D39A"><b><?=$this->Custom->toMoney($ticket_medio)?></b></h3>    
                    <h4 style="color:#16D39A">Tícket Médio Benef.</h4>
                </div>
            </div>
            <div class="col-md-3">
                <div class="w3-card w3-hover-shadow w3-center" style="height:100px"><br>
                    <h3 style="color:#16D39A"><b><?=$this->Custom->toMoney($total)?></b></h3>    
                    <h4 style="color:#16D39A">Valor Total</h4>
                </div>
            </div>
            <div class="col-md-12 mt-1"></div>
        </div>
        <table class="table table-responsive table-stripped datatable" id="tabelamodalcores" style="font-size:12px">
            <thead>
                <th>CNPJ</th>
                <th>Razão Social</th>
                <th>Benef.</th>
                <th>Tícket Médio (R$)</th>
                <th>Valor Total (R$)</th>
                <th>%</th>
            </thead>
            <tbody>
                <?php foreach ($modalcarteira as $item): ?>
                <tr>
                    <td style="text-align:left"><?=$item->cgc_empresa?></td>
                    <td style="text-align:left"><?=$item->razao_social?></td>
                    <td style="text-align:right"><?=$this->Custom->toNumber($item->qtd_pessoas_plano)?></td>
                    <td style="text-align:right"><?=$this->Custom->toFloat($item->ticket_medio)?></td>
                    <td style="text-align:right"><?=$this->Custom->toFloat($item->valor_total)?></td>
                    <td style="text-align:right"><?=($totalvalor == 0) ? '0' : $this->Custom->toFloat($item->valor_total*100/$totalvalor)?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
            <tfoot>
                <th>Total:</th>
                <th></th>
                <th style="text-align:right"></th>
                <th style="text-align:right"><?=($totalvalor == 0) ? 'R$ 0,00' : $this->Custom->toMoney($ticket_medioemp)?></th>
                <th style="text-align:right"></th>
                <th>-</th>
            </tfoot>
        </table>
    </div>
</div>
<script>
$(document).ready(function(){
    $('#tabelamodalcores').DataTable( 
        {
            language: {
                url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                decimal: ",",
                thousands: "."
            },
            dom: 'Bfrtip',
            destroy: true,
            buttons: [
            {
                extend: 'copy',
                text: 'Copiar',
                footer: true
            },
            {
                extend: 'print',
                text: 'Imprimir',
                footer: true
            },
            {
                extend: 'excel',
                filename: 'Empresas Pertencentes ao Setor de Atividade: <?=$setor_atividade?>',
                text: 'Excel',
                exportOptions: {
                    columns: ':visible',
                    format: {
                        body: function(data, row, column, node) {
                            return data.replace('.','').replace(',', '.');
                        }

                    }
                }
            },
            {
                extend: 'pdf',
                filename: 'Empresas Pertencentes ao Setor de Atividade: <?=$setor_atividade?>',
                title:'Empresas Pertencentes ao Setor de Atividade: <?=$setor_atividade?>',
                text: 'PDF',
                orientation:'portrait',
                messageTop: 'Corps Teknologi - Analytics para Gestão Inteligente \n Empresa: <?=$empresa->nome?> \nEmitido em: <?=Date('d/m/y h:i:s')?> Usuário: <?=$usuario?>',
                pageSize:'A4',
                footer: true,
                customize: function(doc,row,column) {
                    doc.defaultStyle.fontSize = 8;
                    doc.styles.tableHeader.fontSize = 8; 
                    doc.styles.tableHeader.fillColor = "#008750"; 
                    doc.styles.tableFooter.fillColor = "#008750"; 
                    doc.styles.tableFooter.fontSize = 8; 
                    doc.defaultStyle.alignment = 'left';
                }
            }
            ],
            responsive: false,
            retrieve: false,
            paging : true,
            order: [[5,"desc"],[4,"desc"],[3,"desc"],[2,"desc"]],
            "footerCallback": function ( row, data, start, end, display ) {
                var totalcolums = [2,4];

                var api = this.api(), data;
                // Remove the formatting to get integer data for summation
                var intVal = function (i) {
                    if(typeof i === 'string'){
                        i = i.toString();
                        i = i.replace('<span style=\"color:red\">', '');
                        i = i.replace('</span>', '');
                    }

                    return typeof i === 'string' ?
                    i.replace(/\./g, '').replace(/\,/g, '.') * 1 :
                    typeof i === 'number' ?
                    i : 0;
                };

                for(i=0;i<totalcolums.length;i++){
                    var col = api .column( totalcolums[i], {filter:'applied'} ).data().reduce( function (a, b) {return intVal(a) + intVal(b);}, 0 );
                    col = col.toLocaleString('pt-BR');
                    col = col < 0 ? '<span style=\"color:red\">'+col+'</span>' : col;
                    $( api.column( totalcolums[i] ).footer() ).html(col);
                }
            },
            "pageLength":10,
            "scrollX" : false,
            fixedHeader: {
                header: false,
                footer: false
            },
            "initComplete": function() {
                window.dispatchEvent(new Event('resize'));
            }
        } 
    );
});
</script>