<table class="table table-responsive table-stripped datatable" id="datatablecores" style="font-size:12px">
    <thead>
        <th >Setores de Atividade</th>
        <th>Empresas</th>
        <th>Benef.</th>
        <th>Tícket Médio <br> por Empresa (R$)</th>
        <th>Tícket Médio <br> por Benef. (R$)</th>
        <th>Valor Total (R$)</th>
        <th>%</th>
    </thead>
    <tbody>
        <?php foreach ($setorescovid as $item): ?>
        <tr style="cursor:pointer" data-target="#modal" data-toggle="modal" target="_BLANK" href="<?=$this->request->getAttribute('base')?>/adm/carteira/modalcarteira/<?=$item->cod_secao?>/<?=$cor?>">
            <td style="text-align:left"><?=$item->nm_secao?></td>
            <td style="text-align:right"><?=$this->Custom->toNumber($item->responsavel_financeiro)?></td>
            <td style="text-align:right"><?=$this->Custom->toNumber($item->qtd_pessoas_plano)?></td>
            <td style="text-align:right"><?=$this->Custom->toFloat($item->ticket_medio_empresa)?></td>
            <td style="text-align:right"><?=$this->Custom->toFloat($item->ticket_medio_beneficiario)?></td>
            <td style="text-align:right"><?=$this->Custom->toFloat($item->valor_total)?></td>
            <td style="text-align:right"><?=($totalvalor == 0) ? '0' : $this->Custom->toFloat($item->valor_total*100/$totalvalor)?></td>
        </tr>
        <?php endforeach; ?>
    </tbody>
    <tfoot>
        <th>Total:</th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th></th>
        <th>-</th>
    </tfoot>
</table>

<script>
$(document).ready(function(){
    $('#datatablecores').DataTable( 
        {
            language: {
                url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                decimal: ",",
                thousands: "."
            },
            dom: 'Bfrtip',
            destroy: true,
            responsive: false,
            buttons: [
            {
                extend: 'copy',
                text: 'Copiar',
                footer: true
            },
            {
                extend: 'print',
                text: 'Imprimir',
                footer: true
            },
            {
                extend: 'excel',
                filename: 'FlyMed - Relação de Setor de Atividade - Onda (<?=($cor == 'GERAL') ? 'Todas' : $cor?>)',
                text: 'Excel',
                exportOptions: {
                    columns: ':visible',
                    format: {
                        body: function(data, row, column, node) {
                            return data.replace('.','').replace(',', '.');
                        }

                    }
                }
            },
            {
                extend: 'pdf',
                filename: 'FlyMed - Relação de Setor de Atividade - Onda (<?=($cor == 'GERAL') ? 'Todas' : $cor?>)',
                title:'FlyMed - Relação de Setor de Atividade - Onda (<?=($cor == 'GERAL') ? 'Todas' : $cor?>)',
                text: 'PDF',
                orientation:'portrait',
                messageTop: 'Corps Teknologi - Analytics para Gestão Inteligente \n Empresa: <?=$empresa->nome?> \nEmitido em: <?=Date('d/m/y h:i:s')?> Usuário: <?=$usuario?>',
                pageSize:'A4',
                footer: true,
                customize: function(doc,row,column) {
                    doc.defaultStyle.fontSize = 8;
                    doc.styles.tableHeader.fontSize = 8; 
                    doc.styles.tableHeader.fillColor = "#008750"; 
                    doc.styles.tableFooter.fillColor = "#008750"; 
                    doc.styles.tableFooter.fontSize = 8; 
                    doc.defaultStyle.alignment = 'left';
                }
            }
            ],
            retrieve: false,
            paging : true,
            order: [[5,"desc"],[4,"desc"],[3,"desc"],[2,"desc"],[1,"desc"]],
            "pageLength":10,
            "scrollX" : false,
            "footerCallback": function ( row, data, start, end, display ) {
                var totalcolums = [1,2,5];

                var api = this.api(), data;
                // Remove the formatting to get integer data for summation
                var intVal = function (i) {
                    if(typeof i === 'string'){
                        i = i.toString();
                        i = i.replace('<span style=\"color:red\">', '');
                        i = i.replace('</span>', '');
                    }

                    return typeof i === 'string' ?
                    i.replace(/\./g, '').replace(/\,/g, '.') * 1 :
                    typeof i === 'number' ?
                    i : 0;
                };

                for(i=0;i<totalcolums.length;i++){
                    var col = api .column( totalcolums[i], {filter:'applied'} ).data().reduce( function (a, b) {return intVal(a) + intVal(b);}, 0 );
                    col = col.toLocaleString('pt-BR');
                    col = col < 0 ? '<span style=\"color:red\">'+col+'</span>' : col;
                    $( api.column( totalcolums[i] ).footer() ).html(col);
                }
            },
            fixedHeader: {
                header: false,
                footer: false
            },
            "initComplete": function() {
                window.dispatchEvent(new Event('resize'));
            }
        } 
    );
	$(function() {
		$('tr[data-toggle="modal"]').on('click', function(e){
			$('.modal-body').html('<div style="text-align:center"><i class="fa fa-refresh fa-spin"></i></div>');
			e.preventDefault();
			$('#modal').modal('show').find('.modal-body').load($(this).attr('href'),function(responseText, textStatus, req){
			if (textStatus == "error") {
				alert('Sua consulta retornou um número muito grande de registros. Tente um período menor.');
				$('[data-dismiss="modal"]').click();
			}
		});
			$('#loading').hide();
		});
		
		$('button[data-dismiss="modal"]').on('click', function(e){
			$('.modal-body').html("");
		});
	});
});
</script>