<div class="row">
    <div class="col-md-3">
        <div class="w3-card w3-hover-shadow w3-center" style="height:100px"><br>
            <h3 style="color:#000000"><b><?=$this->Custom->toNumber($qtd_empresas)?></b></h3>    
            <h4 style="color:#000000">Empresas</h4>
        </div>
    </div>
    <div class="col-md-3">
        <div class="w3-card w3-hover-shadow w3-center" style="height:100px"><br>
            <h3 style="color:#000000"><b><?=$this->Custom->toNumber($qtd_individuos)?></b></h3>    
            <h4 style="color:#000000">Indivíduos</h4>
        </div>
    </div>
    <div class="col-md-3">
        <div class="w3-card w3-hover-shadow w3-center" style="height:100px"><br>
            <h3 style="color:#16D39A"><b><?=$this->Custom->toMoney($ticket_medio)?></b></h3>    
            <h4 style="color:#16D39A">Tícket Médio Benef.</h4>
        </div>
    </div>
    <div class="col-md-3">
        <div class="w3-card w3-hover-shadow w3-center" style="height:100px"><br>
            <h3 style="color:#16D39A"><b><?=$this->Custom->toMoney($total)?></b></h3>    
            <h4 style="color:#16D39A">Valor Total</h4>
        </div>
    </div>
    <div class="col-md-12 mt-1">
        <ul class="nav nav-tabs"  role="tablist">
            <li class="nav-item">
                <a class="nav-link active" onclick="reloadDatatabledivisao()" id="base-tab0" data-toggle="tab" aria-controls="divisoes2" href="#divisoes2" role="tab" aria-selected="false">Divisões</a>
            </li>
            <li class="nav-item">
                <a class="nav-link " onclick="reloadDatatabledivisao()" id="base-tab1" data-toggle="tab" aria-controls="empresas" href="#empresas" role="tab" aria-selected="false">Empresas</a>
            </li>
        </ul>
        <div class="tab-content">
            <div id="divisoes2" class="tab-pane active">
                <table class="table table-responsive table-stripped datatable" id="tabeladivisaomodal" style="font-size:12px; width:100%">
                    <thead>
                        <th>Divisão</th>
                        <th>Empresas</th>
                        <th>Benef.</th>
                        <th>Tícket Médio (R$)</th>
                        <th>Valor Total (R$)</th>
                        <th>Valor Total (%)</th>
                        <th>Valor Aberto (R$)</th>
                        <th>Valor em Aberto (%)</th>
                        <th>Valor Pago (R$)</th>
                        <th>Valor Pago (%)</th>
                        <th>N° Faturas</th>
                        <th>N° Faturas em Aberto</th>
                    </thead>
                    <tbody>
                        <?php $totalnaopago = 0; foreach ($modaldivisao as $item): $totalnaopago += $item->valor_aberto;?>
                        <tr>
                            <td style="text-align:left"><?=$item->nm_divisao?></td>
                            <td style="text-align:left"><?=$item->responsavel_financeiro?></td>
                            <td style="text-align:right"><?=$this->Custom->toNumber($item->qtd_pessoas_plano)?></td>
                            <td style="text-align:right"><?=$this->Custom->toFloat($item->ticket_medio_empresa)?></td>
                            <td style="text-align:right"><?=$this->Custom->toFloat($item->valor_total)?></td>
                            <td style="text-align:right"><?=($totalvalor == 0) ? '0' : $this->Custom->toFloat($item->valor_total*100/$totalvalor)?></td>
                            <td style="text-align:right; color:#FF0000"><?=$this->Custom->toFloat($item->valor_aberto)?></td>
                            <td style="text-align:right; color:#FF0000"><?=($item->valor_total == 0) ? '0' : $this->Custom->toFloat($item->valor_aberto*100/$item->valor_total)?></td>
                            <td style="text-align:right"><?=$this->Custom->toFloat($item->valor_total - $item->valor_aberto)?></td>
                            <td style="text-align:right"><?=($item->valor_total == 0) ? '0' : $this->Custom->toFloat(($item->valor_total - $item->valor_aberto)*100/$item->valor_total)?></td>
                            <td style="text-align:right"><?=$item->boletos?></td>
                            <td style="text-align:right"><?=$item->boletos_atrasados?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                    <tfoot>
                        <th>Total:</th>
                        <th></th>
                        <th style="text-align:right"></th>
                        <th style="text-align:right"></th>
                        <th style="text-align:right"></th>
                        <th style="text-align:right"></th>
                        <th style="text-align:right; color:#FF0000"></th>
                        <th style="text-align:right; color:#FF0000"><?=$this->Custom->toPerc(($totalnaopago),$totalvalor);?></th>
                        <th style="text-align:right"></th>
                        <th style="text-align:right"><?=$this->Custom->toPerc(($totalvalor - $totalnaopago),$totalvalor);?></th>
                        <th style="text-align:right"></th>
                        <th style="text-align:right"></th>
                    </tfoot>
                </table>
            </div>
            <div id="empresas" class="tab-pane">
                <table class="table table-responsive table-stripped datatable" id="tabelaempresasmodal" style="font-size:12px; width:100%">
                    <thead>
                        <th>Impacto</th>
                        <th>CNPJ</th>
                        <th>Razão Social</th>
                        <th>Benef.</th>
                        <th>Tícket Médio (R$)</th>
                        <th>Valor Total (R$)</th>
                        <th>Valor Total (%)</th>
                        <th>Valor Aberto (R$)</th>
                        <th>Valor Aberto (%)</th>
                        <th>Valor Pago (R$)</th>
                        <th>Valor Pago (%)</th>
                        <th>N° Faturas</th>
                        <th>N° Faturas em Aberto</th>
                        <th>Divisão</th>
                        <th>Grupo</th>
                        <th>Classe</th>
                        <th>Subclasse</th>
                    </thead>
                    <tbody>
                        <?php $totalnaopagoemp = 0; foreach ($modalempresadivisao as $item): $totalnaopagoemp += $item->valor_aberto; ?>
                        <tr>
                            <td style="text-align:left"><?=$item->setor?></td>
                            <td style="text-align:left"><?=$item->cgc_empresa?></td>
                            <td style="text-align:left"><?=$item->razao_social?></td>
                            <td style="text-align:right"><?=$this->Custom->toNumber($item->qtd_pessoas_plano)?></td>
                            <td style="text-align:right"><?=$this->Custom->toFloat($item->ticket_medio)?></td>
                            <td style="text-align:right"><?=$this->Custom->toFloat($item->valor_total)?></td>
                            <td style="text-align:right"><?=($totalvalor == 0) ? '0' : $this->Custom->toFloat($item->valor_total*100/$totalvalor)?></td>
                            <td style="text-align:right; color:#FF0000"><?=$this->Custom->toFloat($item->valor_aberto)?></td>
                            <td style="text-align:right; color:#FF0000"><?=($totalvalor == 0) ? '0' : $this->Custom->toFloat($item->valor_aberto*100/$item->valor_total)?></td>
                            <td style="text-align:right"><?=$this->Custom->toFloat($item->valor_total - $item->valor_aberto)?></td>
                            <td style="text-align:right"><?=($totalvalor == 0) ? '0' : $this->Custom->toFloat(($item->valor_total - $item->valor_aberto)*100/$item->valor_total)?></td>
                            <td style="text-align:right"><?=$item->boletos?></td>
                            <td style="text-align:right"><?=$item->boletos_atrasados?></td>
                            <td style="text-align:left"><?=$item->nm_divisao?></td>
                            <td style="text-align:left"><?=$item->nm_grupo?></td>
                            <td style="text-align:left"><?=$item->nm_classe?></td>
                            <td style="text-align:left"><?=$item->nm_cnae?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                    <tfoot>
                        <th>Total:</th>
                        <th></th>
                        <th></th>
                        <th style="text-align:right"></th>                        
                        <th style="text-align:right"><?=($totalvalor == 0) ? 'R$ 0,00' : $this->Custom->toMoney($ticket_medioemp)?></th>
                        <th style="text-align:right"></th>
                        <th style="text-align:right"><?=$this->Custom->toPerc(($totalvalor),$totalvalor)?></th>
                        <th style="text-align:right; color:#FF0000"></th>
                        <th style="text-align:right; color:#FF0000"><?=$this->Custom->toPerc(($totalnaopagoemp),$totalvalor)?></th>
                        <th style="text-align:right"></th>
                        <th style="text-align:right"><?=$this->Custom->toPerc(($totalvalor - $totalnaopagoemp),$totalvalor)?></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th></th>
                        <th>-</th>
                    </tfoot>
                </table>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function(){
    reloadDatatabledivisao()
    $(".select2insidemodal").select2({
    dropdownParent: $("#modalbody")
    })
});

function reloadDatatabledivisao() {
    $('#tabelaempresasmodal').DataTable( 
        {
            language: {
                url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                decimal: ",",
                thousands: "."
            },
            dom: 'Bfrtip',
            destroy: true,
            buttons: [],
            responsive: false,
            retrieve: false,
            paging : true,
            order: [[5,"desc"],[6,"desc"],[7,"desc"]],
            "footerCallback": function ( row, data, start, end, display ) {
                var totalcolums = [3,5,7,9,11,12];

                var api = this.api(), data;
                // Remove the formatting to get integer data for summation
                var intVal = function (i) {
                    if(typeof i === 'string'){
                        i = i.toString();
                        i = i.replace('<span style=\"color:red\">', '');
                        i = i.replace('</span>', '');
                    }

                    return typeof i === 'string' ?
                    i.replace(/\./g, '').replace(/\,/g, '.') * 1 :
                    typeof i === 'number' ?
                    i : 0;
                };

                for(i=0;i<totalcolums.length;i++){
                    var col = api .column( totalcolums[i], {filter:'applied'} ).data().reduce( function (a, b) {return intVal(a) + intVal(b);}, 0 );
                    col = col.toLocaleString('pt-BR');
                    col = col < 0 ? '<span style=\"color:red\">'+col+'</span>' : col;
                    $( api.column( totalcolums[i] ).footer() ).html(col);
                }
            },
            "pageLength":10,
            "scrollX" : false,
            fixedHeader: {
                header: false,
                footer: false
            },
            "initComplete": function() {
                window.dispatchEvent(new Event('resize'));
            }
        } 
    );
    
    $('#tabeladivisaomodal').DataTable( 
        {
            language: {
                url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                decimal: ",",
                thousands: "."
            },
            dom: 'Bfrtip',
            destroy: true,
            buttons: [],
            responsive: false,
            retrieve: false,
            paging : true,
            order: [[5,"desc"],[4,"desc"],[3,"desc"],[2,"desc"]],
            "footerCallback": function ( row, data, start, end, display ) {
                var totalcolums = [1,2,4,5,6,8,10,11];

                var api = this.api(), data;
                // Remove the formatting to get integer data for summation
                var intVal = function (i) {
                    if(typeof i === 'string'){
                        i = i.toString();
                        i = i.replace('<span style=\"color:red\">', '');
                        i = i.replace('</span>', '');
                    }

                    return typeof i === 'string' ?
                    i.replace(/\./g, '').replace(/\,/g, '.') * 1 :
                    typeof i === 'number' ?
                    i : 0;
                };

                for(i=0;i<totalcolums.length;i++){
                    var col = api .column( totalcolums[i], {filter:'applied'} ).data().reduce( function (a, b) {return intVal(a) + intVal(b);}, 0 );
                    col = col.toLocaleString('pt-BR');
                    col = col < 0 ? '<span style=\"color:red\">'+col+'</span>' : col;
                    $( api.column( totalcolums[i] ).footer() ).html(col);
                }
            },
            "pageLength":10,
            "scrollX" : false,
            fixedHeader: {
                header: false,
                footer: false
            },
            "initComplete": function() {
                window.dispatchEvent(new Event('resize'));
            }
        } 
    );
    }
</script>