<?php 
    $session = $this->request->session();
    $empresa = $session->read('login.empresa')->nome;
?>

<h3>Contrato <?=$id?></h3>

<div class="row">
	<div class="col-md-4 col-12" style="margin-top:1%">
		<div class="card h-100 profile-card-with-stats border-teal border-lighten-2">
			<div class="text-center">
				<div class="card-body">
					<img src="../../../webroot/users.png" class="rounded-circle  height-150" alt="Card image">
				</div>
				<div class="card-body">
					<h4 class="card-title">Contrato</h4>
				</div>
				<div class="card-body" style="text-align:left">
				<h3>Dados do Contrato:</h3>
					<div class="row">
                        <div class="col-md-12">
				            <h3>Sinistralidade:</h3>
                        </div>
                        <div class="col-md-4">
							<b>Total Pago:</b> <p><?=($resumo) ? $this->Custom->toMoney($resumo->VALORATRASADO + $resumo->VALOREMDIA + $resumo->VALORANTECIPADO) : '-'?></p>      
                        </div>
                        <div class="col-md-4">
							<b>Total Gasto:</b> <p><?=$this->Custom->toMoney($consumo)?></p>
                        </div>
                        <div class="col-md-4">
							<b>Sinistralidade:</b> <p><?=($resumo) ? $this->Custom->toPerc($consumo,($resumo->VALORATRASADO + $resumo->VALOREMDIA + $resumo->VALORANTECIPADO)) : '-'?></p>
                        </div>
                        <div class="col-md-8">
							<b>Data de Inclusão - Exclusão:</b> <p><?=$data->DATA_INCLUSAO_CONTRATO.' - '.$data->DATA_EXCLUSAO_CONTRATO?></p>
                        </div>
					</div>
                    <hr>
					<div class="row">
                        <div class="col-md-12">
				            <h3>Beneficiários:</h3>
                        </div>
                        <div class="col-md-4">
							<b>Total:</b> <p><?=$beneficiarios?></p>      
                        </div>
                        <div class="col-md-4">
							<b>Consumo Médio:</b> <p><?=$this->Custom->toMoney($consumo/$beneficiarios)?></p>
                        </div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-4 col-12" style="margin-top:1%">
		<div class="card h-100">
            <div class="card-content">
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12 col-sm-12 border-right-blue-grey border-right-lighten-5">
                            <div class="pb-1">
                                <div class="clearfix mb-1">
                                    <i class="icon-check font-large-1 info float-left mt-1"></i>
                                    <span class="font-large-1 text-bold-300 info float-right"><?=$this->Custom->toPerc($resumo->EMDIA,$resumo->TOTAL)?></span>
                                </div>
                                <div class="clearfix">
                                    <span class="font-medium-2 text-bold-1000">Em dia</span>
									<span class="text-bold-400 info float-right"><?=(($resumo) ? $this->Custom->toMoney($resumo->VALOREMDIA) : 'R$ 0,00')?> de <b><?=(($resumo) ? $this->Custom->toNumber($resumo->EMDIA) : 0)?></b> título(s)</span>
                                </div>
                            </div>
                            <div class="progress mb-0" style="height: 7px;">
                                <div class="progress-bar bg-info" role="progressbar" style="width: <?=($resumo) ? $resumo->EMDIA*100/(($resumo->TOTAL == 0) ? 1 : $resumo->TOTAL) : 0?>%" aria-valuenow="<?=($resumo) ? $resumo->EMDIA*100/(($resumo->TOTAL == 0) ? 1 : $resumo->TOTAL) : 0 ?>" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                        </div>
                        <div class="col-lg-12 col-sm-12 border-right-blue-grey border-right-lighten-5" style="margin-top:1%">
                            <div class="pb-1">
                                <div class="clearfix mb-1">
                                    <i class="icon-close font-large-1 danger float-left mt-1"></i>
                                    <span class="font-large-1 text-bold-400 danger float-right">
									<?=( ($resumo) ? $this->Custom->toPerc($resumo->ABERTO,$resumo->TOTAL) : '0%')?>
									</span>
                                </div>
                                <div class="clearfix">
                                    <span class="font-medium-2 text-bold-1000">Aberto</span>
										<span class="text-bold-400 danger float-right"><?=( ($resumo) ? $this->Custom->toMoney($resumo->VALORABERTO) : 'R$ 0,00')?> de <b><?=(($resumo) ? $this->Custom->toNumber($resumo->ABERTO) : '0,00')?></b> título(s)</span>
                                </div>
                            </div>
                            <div class="progress mb-0" style="height: 7px;">
                                <div class="progress-bar bg-danger" role="progressbar" style="width: <?=($resumo) ? $resumo->ABERTO*100/(($resumo->TOTAL == 0) ? 1 : $resumo->TOTAL) : 0?>%" aria-valuenow="<?=($resumo) ? $resumo->ABERTO*100/(($resumo->TOTAL == 0) ? 1 : $resumo->TOTAL) : 0 ?>" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                        </div>
                        <div class="col-lg-12 col-sm-12 border-right-blue-grey border-right-lighten-5" style="margin-top:1%">
                            <div class="pb-1">
                                <div class="clearfix mb-1">
                                    <i class="fa fa-exclamation-triangle font-large-1 warning float-left mt-1"></i>
                                    <span class="font-large-1 text-bold-300 warning float-right"><?=$this->Html->link((($resumo) ? $this->Custom->toPerc($resumo->ATRASADO,$resumo->TOTAL) : '0%'),
											"/adm/contrato/contratotitulo/$id?tipo=atrasado"
											,['class'=>'warning float-right','style'=>'color:white','data-toggle'=>"modal",'data-target'=>"#modal"])?></span>
                                </div>
                                <div class="clearfix">
                                    <span class="font-medium-2 text-bold-1000">Atrasado</span></i>
									<span class="text-bold-400 warning float-right"><?=(($resumo) ? $this->Custom->toMoney($resumo->VALORATRASADO) : 'R$ 0,00')?> de <b><?=(($resumo) ? $this->Custom->toNumber($resumo->ATRASADO) : '0')?> </b>título(s)</span>
                                </div>
                            </div>
                            <div class="progress mb-0" style="height: 7px;">
                                <div class="progress-bar bg-warning" role="progressbar" style="width: <?=($resumo) ? $resumo->ATRASADO*100/(($resumo->TOTAL == 0) ? 1 : $resumo->TOTAL) : 0 ?>%" aria-valuenow="<?=($resumo) ? $resumo->ATRASADO*100/(($resumo->TOTAL == 0) ? 1 : $resumo->TOTAL) : 0?>" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                        </div>
                        <div class="col-lg-12 col-sm-12" style="margin-top:1%">
                            <div class="pb-1">
                                <div class="clearfix mb-1">
                                    <i class="icon-check font-large-1 success float-left mt-1"></i>
                                    <span class="font-large-1 text-bold-300 success float-right">
									<?=$this->Html->link((($resumo) ? $this->Custom->toPerc($resumo->ANTECIPADO,$resumo->TOTAL) : '0%'),
										"/adm/contrato/contratotitulo/$id?tipo=antecipado"
										,['class'=>'success float-right','style'=>'color:white','data-toggle'=>"modal",'data-target'=>"#modal"])?></span>
                                </div>
                                <div class="clearfix">
                                    <span class="font-medium-2 text-bold-1000">Antecipado</span>
                                    <span class="success float-right"><!--<i class="ft-arrow-up success"></i>-->
									<?=(($resumo) ? $this->Custom->toMoney($resumo->VALORANTECIPADO) : 'R$ 0,00')?> de <b><?=(($resumo) ? $this->Custom->toNumber($resumo->ANTECIPADO) : 0)?></b> título(s)
                                </div>
                            </div>
                            <div class="progress mb-0" style="height: 7px;">
                                <div class="progress-bar bg-success" role="progressbar" style="width: <?=($resumo) ? $resumo->ANTECIPADO*100/(($resumo->TOTAL == 0) ? 1 : $resumo->TOTAL) : 0?>%" aria-valuenow="<?=($resumo) ? $resumo->ANTECIPADO*100/(($resumo->TOTAL == 0) ? 1 : $resumo->TOTAL) : 0 ?>" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                        </div>
						<div class="col-md-12">
						<hr>
						</div>

                        <div class="col-lg-12 col-sm-12" style="margin-top:1%">
                            <div class="pb-1">
                                <div class="clearfix mb-1">
                                    <i class="fa fa-money font-large-1 success float-left mt-1"></i>
                                    <span class="font-large-1 text-bold-300 success float-right">
									<?=($resumo) ? $this->Custom->toPerc($resumo->ATRASADO + $resumo->EMDIA + $resumo->ANTECIPADO,$resumo->TOTAL) : '0%'?>
									</span>
                                </div>
                                <div class="clearfix">
                                    <span class="font-medium-2 text-bold-1000">Total Pago</span>
                                    <span class="success float-right">
									<?=($resumo) ? $this->Custom->toMoney($resumo->VALORATRASADO + $resumo->VALOREMDIA + $resumo->VALORANTECIPADO) : 'R$ 0,00'?> de <b> <?=($resumo) ? $this->Custom->toNumber($resumo->ATRASADO + $resumo->EMDIA + $resumo->ANTECIPADO) : 0?></b> título(s)</span>
                                </div>
                            </div>
                            <div class="progress mb-0" style="height: 7px;">
                                <div class="progress-bar bg-success" role="progressbar" style="width: <?=($resumo) ? ($resumo->ATRASADO + $resumo->EMDIA + $resumo->ANTECIPADO)*100/$resumo->TOTAL : 0?>%" aria-valuenow="<?=($resumo) ? ($resumo->ATRASADO + $resumo->EMDIA + $resumo->ANTECIPADO)*100/$resumo->TOTAL : 0?>" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                        </div>

                        <div class="col-lg-12 col-sm-12" style="margin-top:1%">
                            <div class="pb-1">
                                <div class="clearfix mb-1">
                                    <i class="icon-wallet font-large-1 warning float-left mt-1"></i>
                                    <span class="font-large-1 text-bold-300 warning float-right"><?=($resumo) ? $this->Custom->toPerc($consumo, ($resumo->VALORATRASADO + $resumo->VALOREMDIA + $resumo->VALORANTECIPADO)) : '0%'?></span>
                                </div>
                                <div class="clearfix">
                                    <span class="font-medium-2 text-bold-1000">Total Consumido</span>
                                    <span class="warning float-right"></i> <?= $this->Custom->toMoney($consumo)?></span>
                                </div>
                            </div>
                            <div class="progress mb-0" style="height: 7px;">
                                <div class="progress-bar bg-warning" role="progressbar" style="width: <?=($resumo) ? ($consumo*100/($resumo->VALORATRASADO + $resumo->VALOREMDIA + $resumo->VALORANTECIPADO)) : 0?>%" aria-valuenow="<?=($resumo) ? ($consumo*100/($resumo->VALORATRASADO + $resumo->VALOREMDIA + $resumo->VALORANTECIPADO)) : 0?>" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                        </div>

                    </div>
                </div>
            </div>
        </div>
	</div>
	<div class="col-md-4 col-12" style="margin-top:1%">
		<div class="card h-100">
			<div class="card-body">
				<b>Proporção dos indicadores Financeiros</b>
				<div id="pie" style="margin-top:2%" class="height-500 echart-container"></div>
				<div class="row">
					<div class="col-md-12">
						<hr>
					</div>
					<div class="col-lg-12 col-md-12 col-sm-12 border-right-blue-grey border-right-lighten-5">
						<div class="p-1  text-center">
							<div>
								<h4 class="blue-grey darken-1">
									Total<br>
									<?=($resumo) ? $this->Custom->toMoney($resumo->VALORTOTAL) : '-'?>
								</h4>
								<span class="blue-grey darken-1">
									de <b> <?=($resumo) ? $this->Custom->toNumber($resumo->TOTAL) : '-'?></b> título(s)
								</span>
							</div>
						</div>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<br>
<script>
var antecipado = <?=round($resumo->VALORANTECIPADO,2)?>;
var emdia = <?=round($resumo->VALOREMDIA,2)?>;
var atrasado = <?=round($resumo->VALORATRASADO,2)?>;
var aberto = <?=round($resumo->VALORABERTO,2)?>;
var myChart50 = echarts.init(document.getElementById('pie'));
var yMax = 80;
option = {
    tooltip: {
        trigger: 'item',
        formatter: "{a} <br/>{b} : {c} ({d}%)"
    },
    legend: {
        data:['Antecipado', 'Em dia', 'Atrasado', 'Aberto']
    },
	
    color: ['#33bb33', '#3333bb', '#fc9339','#dd3333'],
    series : [
        {
            name: '',
            type: 'pie',
            radius : '55%',
            center: ['50%', '60%'],
			data: [
				{value:antecipado, name:'Antecipado', itemStyle: {color: 'green'}},
				{value:emdia, name:'Em dia', itemStyle: {color: '#add8e6'}},
				{value:atrasado, name:'Atrasado', itemStyle: {color: '#fed8b1'}},
				{value:aberto, name:'Aberto', itemStyle: {color: 'red'}}
			]
		}
	]
};

myChart50.setOption(option);
    myChart50.resize();

    // Resize chart
    // ------------------------------

    $(function () {

        // Resize chart on menu width change and window resize
        $(window).on('resize', resize);
        $(".menu-toggle").on('click', resize);

        // Resize function
        function resize() {
            setTimeout(function() {

                // Resize chart
                myChart50.resize();
            }, 200);
        }
    });
</script>