<div class="card">
    <div class="card-header">
        <h3>Edição do Paciente <?=$paciente->carteiracpf?></h3>
    </div>
    <div class="card-body">
    <form action="../dashboardcorona/edicaomodal/<?=$paciente->entradapacientesid?>" method="POST">
        <div class="row">
            <div class='col-md-6'>
                <b>Hospital</b><br>
                <select name="hospitalid" id="" class="form-control">
                    <?php foreach ($hospitais as $item): ?>
                        <option <?=($item->hospitalid == $paciente->hospitalid) ? 'selected' : '' ?> value="<?=$item->hospitalid?>"><?=$item->nomefantasia?></option>
                    <?php endforeach; ?>
                </select>
            </div>
            <div class='col-md-6'>
                <b>Número Carteirinha / CPF:</b><br>
                <input type="text" name='carteiracpf' value="<?=$paciente->carteiracpf?>" required class='form-control'>
            </div>
            <div class='col-md-6'>
                <b>Tipo de Paciente:</b><br>
                <select name="tipo" id="tipo" class='form-control'>
                    <option <?=('Diag. Suspeito' == $paciente->tipo) ? 'selected' : '' ?> value="Diag. Suspeito">Diag. Suspeito</option>
                    <option <?=('Diag. Confirmado' == $paciente->tipo) ? 'selected' : '' ?> value="Diag. Confirmado">Diag. Confirmado</option>
                    <option <?=('Descartado' == $paciente->tipo) ? 'selected' : '' ?> value="Descartado">Descartado</option>
                </select>
            </div>
            <div class='col-md-6'>
                <b>Grupo de risco</b>
                <select name="gruporisco[]" multiple class="form-control" id="selectnovo">
                    <option <?=(in_array('Não',$gruposrisco)) ? 'selected' : '' ?> value="Não">Não</option>
                    <option <?=(in_array('Diabético',$gruposrisco)) ? 'selected' : '' ?> value="Diabético">Diabético</option>
                    <option <?=(in_array('Crônico',$gruposrisco)) ? 'selected' : '' ?> value="Crônico">Crônico</option>
                    <option <?=(in_array('Hipertenso',$gruposrisco)) ? 'selected' : '' ?> value="Hipertenso">Hipertenso</option>
                    <option <?=(in_array('Problemas Respiratórios',$gruposrisco)) ? 'selected' : '' ?> value="Problemas Respiratórios">Problemas Respiratórios</option>
                    <option <?=(in_array('Renal Crônico',$gruposrisco)) ? 'selected' : '' ?> value="Renal Crônico">Renal Crônico</option>
                </select>
            </div>
            <div class='col-md-6' style="margin-bottom:0% !important">
                <b>Local:</b><br>
                <select name="local" id="local" class='form-control'>
                    <option <?=('UTI' == $paciente->local) ? 'selected' : '' ?> value="UTI">UTI</option>
                    <option <?=('Enfermaria' == $paciente->local) ? 'selected' : '' ?> value="Enfermaria">Enfermaria</option>
                    <option <?=('Isolamento Domiciliar' == $paciente->local) ? 'selected' : '' ?> value="Isolamento Domiciliar">Isolamento Domiciliar</option>
                    <option <?=('UCI' == $paciente->local) ? 'selected' : '' ?> value="UCI">UCI Semi-Intensivo</option>
                </select>
            </div>
            <div class="col-md-6"><br>
                <b>Teste Colhido:</b>
                <label class="switch">
                    <input type="checkbox" <?=($paciente->testecolhido) ? 'checked' : '' ?> name="testecolhido">
                    <span class="slider2 round">
                    </span>
                </label>
                <b style="margin-left:10px">Ventilação Mecânica:</b>
                <label class="switch">
                    <input type="checkbox" <?=($paciente->ventilacao) ? 'checked' : '' ?> name="ventilacao">
                    <span class="slider2 round">
                    </span>
                </label>
                <b style="margin-left:10px">Houve Alta:</b>
                <label class="switch">
                    <input type="checkbox" <?=($paciente->alta) ? 'checked' : '' ?> name="alta">
                    <span class="slider2 round">
                    </span>
                </label>
            </div>
            
            <div class="col-md-6"><b>Observação:</b>
                <textarea name="observacao" class="form-control" id=""><?=$paciente->observacao?></textarea>
            </div>
            <div class="col-md-6">
                <b>Cód. Teste:</b>
                <input type="text" class="form-control" value="<?=$paciente->codigoteste?>" name="codigoteste">
            </div>
            <div class="col-md-6"><br>
                <button class="btn btn-primary" type="submit">Enviar</button>
            </div>
        </div>

    </form>
    </div>
</div>

<script>
$(document).ready(function() {
    $('#selectnovo').select2();
});
</script>