<?php

?>

<ul class="nav nav-tabs"  role="tablist">
    <li class="nav-item">
        <a class="nav-link " id="base-tab1" data-toggle="tab" aria-controls="mundo" href="#mundo" onclick="loadiframemundial()" role="tab" aria-selected="false">Mundo</a>
    </li>
    <li class="nav-item">
        <a class="nav-link " id="base-tab2" data-toggle="tab" aria-controls="br" onclick="loadiframebr()" href="#br" role="tab" aria-selected="false">Brasil</a>
    </li>
    <li class="nav-item">
        <a class="nav-link active" id="base-tab4" data-toggle="tab" aria-controls="unimednatal" href="#unimednatal" onclick="loadunimed();setTimeout(window.dispatchEvent(new Event('resize')),200)" role="tab" aria-selected="true"><?=$empresa->nome?></a>
    </li>
    <li class="nav-item">
        <a class="nav-link" id="base-tab4" data-toggle="tab" aria-controls="hospitais" onclick="setTimeout(window.dispatchEvent(new Event('resize')),200);reloadGraph2()" href="#hospitais" role="tab" aria-selected="false">Hospitais</a>
    </li>
    <?php if (in_array('homecare',$modulosuser)) { ?>
    <li class="nav-item">
        <a class="nav-link" id="base-tab5" data-toggle="tab" aria-controls="gpad" onclick="loadgpad();setTimeout(window.dispatchEvent(new Event('resize')),200)" href="#gpad" role="tab" aria-selected="false">Home Care</a>
    </li>
    <?php } ?>
</ul>
<br>
<div class="tab-content">
    <div id="mundo" class="tab-pane">
        <div class="card">
            <div class="card-header">
                <label class="card-title"><b>Cenário Mundial</b></label> - Fonte: <a href="https://who.sprinklr.com/#">World Health Organization</a>
                <a class="heading-elements-toggle"></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i id='iconn' class="fa fa-plus"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <iframe id="iframemundial" src="" width="100%" height="1000px"></iframe>
            </div>
        </div>
    </div>
    <div id="br" class="tab-pane">
        <div class="card">
            <div class="card-header">
                <label class="card-title"><b>Cenário Brasil</b></label> - Fonte: <a href="https://covid.saude.gov.br/">Ministério da Saúde</a>
                <a class="heading-elements-toggle"></a>
                <div class="heading-elements">
                    <ul class="list-inline mb-0">
                        <li><a data-action="collapse"><i id='iconn' class="fa fa-plus"></i></a></li>
                    </ul>
                </div>
            </div>
            <div class="card-content collapse show">
                <iframe id="iframebr" src="" width="100%" height="1000px"></iframe>
            </div>
        </div>
    </div>
    <div id="hospitais" class="tab-pane">
        <div class="row">
            <div class="col-md-12">
                <div class="card">
                    <div class="card-body" style="text-align:center">
                        <strong>Internações por dia (Todos os Hospitais)</strong>
                        <div id='internadosgeral' class="echart-container"  style="width: 100%;text-align:center;min-height: 350px"></div>
                    </div>
                </div>
            </div>
            <?php foreach ($hospitaisid as $item) : ?>
            <div class="col-md-6">
                <div class="card">
                    <div class="card-body" style="text-align:center">
                        <strong>Internações por dia <br> <?=$this->Custom->get('Hospital','hospitalid',$item)->nomefantasia?></strong>
                        <div id='internados<?=$item?>' class="echart-container"  style="width: 100%;text-align:center;min-height: 350px"></div>
                    </div>
                </div>
            </div>
            <?php endforeach; ?>
        </div>
    </div>
    <div id="unimednatal" class="tab-pane active">
        <div id="arenacontentunimed"></div>
    </div>
    <div id="gpad" class="tab-pane">
        <div id="arenacontentgpad"></div>
    </div>
</div>

<script type="text/javascript">

function loadiframebr() {
    $("#iframebr").attr("src", "https://covid.saude.gov.br/");
}
function loadiframemundial() {
    $("#iframebr").attr("src", "https://who.sprinklr.com/#");
}

    $(document).ready(function() {
        $('#cidades').DataTable();
    } );
    function loadunimed(){
        var url =  encodeURI("unimeddetalhamento");
        $('#loading').show();
        $('#arenacontentunimed').load("./dashboardcorona/"+url,function(){
            $('#loading').hide();
        });
    }
    function loadgpad() {
        var url =  encodeURI("gpad");
        $('#loading').show();
        $('#arenacontentgpad').load("./dashboardcorona/"+url,function(){
            $('#loading').hide();
        });
    }
    loadunimed();
    
function reloadGraph2() {
    var myChart5 = echarts.init(document.getElementById('internadosgeral'));
    option = {
        tooltip: {
            trigger: 'axis'
        },
        legend: {
            data: ['Internações','UTI','UCI','Enfermaria','Ventilação']
        },
        grid: {
            left: '3%',
            right: '4%',
            bottom: '3%',
            top:'22%',
            containLabel: true
        },
        toolbox: {
            feature: {
                saveAsImage: {title:'Download'}
            }
        },
        xAxis: {
            type: 'category',
            boundaryGap: false,
            data: ['<?=implode('\',\'',$datas)?>']
        },
        yAxis: {
            type: 'value',
            name: '  Beneficiários',
            orient: 'vertical'
        },
        grid: { bottom: 60 },
        grid: { top: 80 },
        dataZoom: [{
            type: 'inside',
            start: 40,
            end: 100
        }, {
            start: 0,
            end: 40,
            handleIcon: 'M10.7,11.9v-1.3H9.3v1.3c-4.9,0.3-8.8,4.4-8.8,9.4c0,5,3.9,9.1,8.8,9.4v1.3h1.3v-1.3c4.9-0.3,8.8-4.4,8.8-9.4C19.5,16.3,15.6,12.2,10.7,11.9z M13.3,24.4H6.7V23h6.6V24.4z M13.3,19.6H6.7v-1.4h6.6V19.6z',
            handleSize: '80%',
            handleStyle: {
                color: '#fff',
                shadowBlur: 3,
                shadowColor: 'rgba(0, 0, 0, 0.6)',
                shadowOffsetX: 2,
                shadowOffsetY: 2
            }
        }],
        series: [
            {
                name: 'Internações',
                type: 'line',
                data: [<?=implode(',',$internacoesgeral)?>],
                color: '#000000'
            },
            {
                name: 'UTI',
                type: 'line',
                itemStyle: {
                    color: 'rgb(237,69,69)'
                },
                stack: 'a',
                areaStyle: {
                },
                data: [<?=implode(',',$utigeral)?>]
            },
            {
                name: 'UCI',
                type: 'line',
                itemStyle: {
                    color: 'rgb(31,161,141)'
                },
                stack: 'a',
                areaStyle: {
                },
                data: [<?=implode(',',$ucigeral)?>]
            },
            {
                name: 'Enfermaria',
                type: 'line',
                itemStyle: {
                    color: 'rgb(53,240,103)'
                },
                stack: 'a',
                areaStyle: {
                },
                data: [<?=implode(',',$enfermariageral)?>]
            },
            {
                name: 'Ventilação',
                type: 'line',
                data: [<?=implode(',',$ventilacaogeral)?>],
                color: '#000000'
            }
        ]
    };

    myChart5.setOption(option);


    // Resize chart
    // ------------------------------

    $(function () {

    // Resize chart on menu width change and window resize
    $(window).on('resize', resize);
    $(".menu-toggle").on('click', resize);

    // Resize function
    function resize() {
        setTimeout(function() {

            // Resize chart
            myChart5.resize();
        }, 200);
    }
    });
    <?php foreach ($hospitaisid as $item): ?>
    <?php 
        $arraydata = [];
        $arraysoma = [];
        $arrayuti = [];
        $arrayuci = [];
        $arrayenfermaria = [];
        $arrayventilacao = [];
        foreach ($arrayhospitais as $item2) {
            if (empty($item2)) {

            } else {
                if ($item2[0][6] == $item) {
                    foreach ($item2 as $item3) {
                        array_push($arraydata, $item3[5]);
                        array_push($arraysoma, $item3[0]);
                        array_push($arrayuti, $item3[1]);
                        array_push($arrayuci, $item3[2]);
                        array_push($arrayenfermaria, $item3[3]);
                        array_push($arrayventilacao, $item3[4]);
                    }
                }
            }
        }
    echo "var myChart".$item." = echarts.init(document.getElementById('internados".$item."'));";
    echo "option = {
        tooltip: {
            trigger: 'axis'
        },
        legend: {
            data: ['Internações','UTI','UCI','Enfermaria','Ventilação']
        },
        grid: {
            left: '3%',
            right: '4%',
            bottom: '3%',
            top:'22%',
            containLabel: true
        },
        toolbox: {
            feature: {
                saveAsImage: {title:'Download'}
            }
        },
        xAxis: {
            type: 'category',
            boundaryGap: false,
            data: ['".implode('\',\'',$arraydata)."']
        },
        
        yAxis: {
            type: 'value',
            name: '  Beneficiários'
        },
        grid: { bottom: 60 },
        grid: { top: 80 },
        dataZoom: [{
            type: 'inside',
            start: 40,
            end: 100
        }, {
            start: 0,
            end: 40,
            handleIcon: 'M10.7,11.9v-1.3H9.3v1.3c-4.9,0.3-8.8,4.4-8.8,9.4c0,5,3.9,9.1,8.8,9.4v1.3h1.3v-1.3c4.9-0.3,8.8-4.4,8.8-9.4C19.5,16.3,15.6,12.2,10.7,11.9z M13.3,24.4H6.7V23h6.6V24.4z M13.3,19.6H6.7v-1.4h6.6V19.6z',
            handleSize: '80%',
            handleStyle: {
                color: '#fff',
                shadowBlur: 3,
                shadowColor: 'rgba(0, 0, 0, 0.6)',
                shadowOffsetX: 2,
                shadowOffsetY: 2
            }
        }],
        series: [
            {
                name: 'Internações',
                type: 'line',
                data: [".implode(',',$arraysoma)."],
                color: '#000000'
            },
            {
                name: 'UTI',
                type: 'line',
                itemStyle: {
                    color: 'rgb(237,69,69)'
                },
                stack: 'a',
                areaStyle: {
                },
                data: [".implode(',',$arrayuti)."]
            },
            {
                name: 'UCI',
                type: 'line',
                itemStyle: {
                    color: 'rgb(31,161,141)'
                },
                stack: 'a',
                areaStyle: {
                },
                data: [".implode(',',$arrayuci)."]
            },
            {
                name: 'Enfermaria',
                type: 'line',
                itemStyle: {
                    color: 'rgb(53,240,103)'
                },
                stack: 'a',
                areaStyle: {
                },
                data: [".implode(',',$arrayenfermaria)."]
            },
            {
                name: 'Ventilação',
                type: 'line',
                data: [".implode(',',$arrayventilacao)."],
                color: '#000000'
            }
        ]
    };";

    ?>
    myChart<?=$item?>.setOption(option);


    // Resize chart
    // ------------------------------

    $(function () {

    // Resize chart on menu width change and window resize
    $(window).on('resize', resize);
    $(".menu-toggle").on('click', resize);

    // Resize function
    function resize() {
        setTimeout(function() {

            // Resize chart
            myChart<?=$item?>.resize();
        }, 200);
    }
    });
    <?php endforeach; ?>
}
reloadGraph2();
</script>