<div class="row mt-1">
    <div class="col-md-4">
        <strong>Hospitais</strong>
        <select id="hospital" onchange="reloadKanban()" class="form-control">
            <option value="todos">.: Selecione um Hospital :.</option>
            <?php foreach ($hospitais as $item): ?>
            <option value="<?=$item->hospitalid?>" <?=$item->hospitalid == $hospital ? 'selected' : ''?>><?=$item->nomefantasia?></option>
            <?php endforeach; ?>
        </select>
    </div>
    <div class="col-md-4">
        <strong>Buscar Paciente</strong>
        <input type="text" id="carteirinha" value="<?=$carteirinha?>" placeholder="Informe o Número da Carteirinha ou Cpf" class="form-control" onfocusout="reloadKanban()">
    </div>
    <div class="col-md-4" id="periodo">
        <b>Período</b>
        <div class='input-group'>
            <input value="<?=date('d/m/Y').' - '.date('d/m/Y')?>" name="periodo" id="filtroperiodo" type='text' class="form-control shawCalRanges" />
        </div>
    </div>
</div>
<div class="row mt-1">
    <div style="overflow: auto">
        <div class="scrolling-wrapper">
            <div class="panel panel-primary kanban-col" style="min-width: 350px">
                <div class="">
                    <h3 class="text-center" style="margin-top:2%">Internados (<?=count($internados)?>)</h3><div class="" style="margin-right:10px; font-size:20px; text-align:center"><i title="Teste Colhido" class="fas fa-syringe" style="color:#000000 !important"></i> <?=$internadotest?> | <i title="Utilizando Ventilação Mecânica" class="fas fa-lungs" style="color:#FF3558 !important"></i>&nbsp;<?=$internadovent?> | <i title="UTI" class="fas fa-heartbeat" style="color:#008750 !important"></i>&nbsp;<?=$internadouti?></div>
                </div>
                <div class="panel-body">
                    <div id="Internados" class="kanban-centered ">
                    <?php foreach ($internados as $item): ?>
                        <article class="kanban-entry"  id="<?=$item->prontuarioatendimentoid?> ">
                            <div class="kanban-entry-inner">
                                <a data-target="#modal" data-toggle="modal" target="_BLANK" href="<?=$this->request->getAttribute('base')?>/adm/dashboardcorona/modalentrada/<?=$item->prontuarioatendimentoid?>">
                                <div class="kanban-label row <?php if ($item->tipo == 'Diag. Confirmado') { echo 'bg-danger';} else if ($item->tipo == 'Diag. Suspeito') {echo 'bg-warning';} else {echo 'bg-success';}?>">
                                    <div class="col-md-12 text-dark">
                                        <h2 class="text-secondary"><?=$item->carteiracpf?> &nbsp;<div class="float-right"><?php if ($item->testecolhido) { ?><i class="fas fa-syringe" style="color:#000000 !important"></i><?php } ?>&nbsp;<?php if ($item->ventilacao) { ?><i class="fas fa-lungs" style="color:#FF3558 !important"></i><?php } ?>&nbsp;<?php if ($item->local == 'UTI') { ?><i class="fas fa-heartbeat" style="color:#008750 !important"></i><?php } ?></div></h2>
                                        <b><?=$item->tipo?></b> <b><?='| '.$item->gruporisco?></b>
                                    </div>
                                    <div class="col-md-12">
                                        <?php $hoje = new DateTime(Date('Y-m-d H:i:s')); $cadastro = new DateTime(Date('Y-m-d H:i:s', strtotime($item->data_entrada))); ?>
                                        <b class="text-secondary"><?=$this->Custom->formatDataHora($item->data_entrada)?></b> <b class="text-secondary"><?=' | '.$hoje->diff($cadastro)->days?> Dia(s)</b>
                                    </div>
                                </div>
                                </a>
                            </div>
                        </article>
                    <?php endforeach; ?>
                    </div>
                </div>
            </div>
            <div class="panel panel-primary kanban-col" style="min-width: 350px">
                <div class="">
                    <h3 class="text-center" style="margin-top:2%">Alta (<?=count($altas)?>)</h3><div class="" style="margin-right:10px; font-size:20px; text-align:center"><i title="Teste Colhido" class="fas fa-syringe" style="color:#000000 !important"></i> <?=$altatest?> | <i title="Utilizando Ventilação Mecânica" class="fas fa-lungs" style="color:#FF3558 !important"></i>&nbsp;<?=$altavent?> | <i title="UTI" class="fas fa-heartbeat" style="color:#008750 !important"></i>&nbsp;<?=$altauti?></div>
                </div>
                <div class="panel-body">
                    <div id="Alta" class="kanban-centered">
                    <?php foreach ($altas as $item): ?>
                        <article class="kanban-entry grab" id="<?=$item->prontuarioatendimentoid?> ">
                            <div class="kanban-entry-inner">
                        <a data-target="#modal" data-toggle="modal" target="_BLANK" href="<?=$this->request->getAttribute('base')?>/adm/dashboardcorona/modalentrada/<?=$item->prontuarioatendimentoid?>">
                                <div class="kanban-label row <?php if ($item->tipo == 'Diag. Confirmado') { echo 'bg-danger';} else if ($item->tipo == 'Diag. Suspeito') {echo 'bg-warning';} else {echo 'bg-success';}?>">
                                    <div class="col-md-12 text-dark">
                                        <h2 class="text-secondary"><?=$item->carteiracpf?> &nbsp;<div class="float-right"><?php if ($item->testecolhido) { ?><i class="fas fa-syringe" style="color:#000000 !important"></i><?php } ?>&nbsp<?php if ($item->ventilacao) { ?><i class="fas fa-lungs" style="color:#FF3558 !important"></i><?php } ?> &nbsp;<?php if ($item->local == 'UTI') { ?><i class="fas fa-heartbeat" style="color:#008750 !important"></i><?php } ?></div></h2>
                                        <b><?=$item->tipo?></b> <b><?='| '.$item->gruporisco?></b>
                                    </div>
                                    <div class="col-md-12">
                                        <?php $hoje = new DateTime(Date('Y-m-d H:i:s', strtotime($item->data_alta))); $cadastro = new DateTime(Date('Y-m-d H:i:s', strtotime($item->data_entrada))); ?>
                                        <b class="text-secondary"><?=$this->Custom->formatDataHora($item->data_entrada)?></b> <b class="text-secondary"><?=' | '.$hoje->diff($cadastro)->days?> Dia(s)</b>
                                    </div>
                                </div>
                        </a>
                            </div>
                        </article>
                    <?php endforeach; ?>
                    </div>
                </div>
            </div>
            <div class="panel panel-primary kanban-col" style="min-width: 350px">
                <div class="">
                    <h3 class="text-center" style="margin-top:2%">Óbitos (<?=count($obitos)?>)</h3><div class="" style="margin-right:10px; font-size:20px; text-align:center"><i title="Teste Colhido" class="fas fa-syringe" style="color:#000000 !important"></i> <?=$obitotest?> | <i title="Utilizando Ventilação Mecânica" class="fas fa-lungs" style="color:#FF3558 !important"></i>&nbsp;<?=$obitovent?> | <i title="UTI" class="fas fa-heartbeat" style="color:#008750 !important"></i>&nbsp;<?=$obitouti?></div>
                </div>
                <div class="panel-body">
                    <div id="Obito" class="kanban-centered">
                    <?php foreach ($obitos as $item): ?>
                        <article class="kanban-entry grab" id="<?=$item->prontuarioatendimentoid?> ">
                            <div class="kanban-entry-inner">
                        <a data-target="#modal" data-toggle="modal" target="_BLANK" href="<?=$this->request->getAttribute('base')?>/adm/dashboardcorona/modalentrada/<?=$item->prontuarioatendimentoid?>">
                                <div class="kanban-label row <?php if ($item->tipo == 'Diag. Confirmado') { echo 'bg-danger';} else if ($item->tipo == 'Diag. Suspeito') {echo 'bg-warning';} else {echo 'bg-success';}?>">
                                    <div class="col-md-12 text-dark">
                                        <h2 class="text-secondary"><?=$item->carteiracpf?> &nbsp;<div class="float-right"><?php if ($item->testecolhido) { ?><i class="fas fa-syringe" style="color:#000000 !important"></i><?php } ?>&nbsp<?php if ($item->ventilacao) { ?><i class="fas fa-lungs" style="color:#FF3558 !important"></i><?php } ?> &nbsp;<?php if ($item->local == 'UTI') { ?><i class="fas fa-heartbeat" style="color:#008750 !important"></i><?php } ?></div></h2>
                                        <b><?=$item->tipo?></b> <b><?='| '.$item->gruporisco?></b>
                                    </div>
                                    <div class="col-md-12">
                                        <?php $hoje = new DateTime(Date('Y-m-d H:i:s', strtotime($item->data_obito))); $cadastro = new DateTime(Date('Y-m-d H:i:s', strtotime($item->data_entrada))); ?>
                                        <b class="text-secondary"><?=$this->Custom->formatDataHora($item->data_entrada)?></b> <b class="text-secondary"><?=' | '.$hoje->diff($cadastro)->days?> Dia(s)</b>
                                    </div>
                                </div>
                        </a>
                            </div>
                        </article>
                    <?php endforeach; ?>
                    </div>
                </div>
            </div>
        </div>
        </div>
    </div>
</div>


<script> 
    document.body.style.zoom = 0.8;
</script>

<script>
	$(function() {
		$('a[data-toggle="modal"]').on('click', function(e){
			$('.modal-body').html('<div style="text-align:center"><i class="fa fa-refresh fa-spin"></i></div>');
			e.preventDefault();
			$('#modal').modal('show').find('.modal-body').load($(this).attr('href'),function(responseText, textStatus, req){
			if (textStatus == "error") {
				alert('Sua consulta retornou um número muito grande de registros. Tente um período menor.');
				$('[data-dismiss="modal"]').click();
			}
		});
			$('#loading').hide();
		});
		
		$('button[data-dismiss="modal"]').on('click', function(e){
			$('.modal-body').html("");
		});
	});

function reloadKanban() {
        let hospital = $('#hospital')[0].selectedOptions[0].value
        let carteirinha = $('#carteirinha').val()
        let url =  encodeURI("kanban/"+hospital+"/"+carteirinha)
        $('#loading').show();
        $('#arenacontentkanban').load("../dashboardcorona/"+url,function(){
            $('#loading').hide();
        });
    }
    
setTimeout(function() {
    var f = "DD/MM/Y";
    $('.shawCalRanges').daterangepicker({
        ranges: {
            'Hoje': [moment().format(f), moment().format(f)],
            'Ontem': [moment().subtract(1, 'days').format(f), moment().subtract(1, 'days').format(f)],
            'Últimos 7 dias': [moment().subtract(6, 'days').format(f), moment().format(f)],
            'Esse mês': [moment().startOf('month').format(f), moment().endOf('month').format(f)],
            'Mês passado': [moment().subtract(1, 'month').startOf('month').format(f), moment().subtract(1, 'month').endOf('month').format(f)],
            'Esse ano': [moment().startOf('year').format(f), moment().endOf('year').format(f)],
            'Ano passado': [moment().subtract(1, 'year').startOf('year').format(f), moment().subtract(1, 'year').endOf('year').format(f)]
        },
        locale: {
            format: 'DD/MM/YYYY',
            applyLabel: "Ok",
            cancelLabel: 'Cancelar',
            startLabel: 'Início',
            endLabel: 'Fim',
            customRangeLabel: 'Período',
            daysOfWeek: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex','Sáb'],
            monthNames: ['Janeiro','Fevereiro','Março','Abril','Maio','Junho','Julho','Agosto','Setembro','Outubro','Novembro','Dezembro'],
            firstDay: 1
        },
            alwaysShowCalendars: true,
    });
}, 1000);
</script>