
<h2><?=$hospital?></h2><div class="float-right"><b>Atualizado em:</b> <?=Date('d/m/Y H:i:s')?></div><br><br>
<div class="row">
    <div class="col-md-3">
        <div class="w3-card w3-hover-shadow w3-center" style="height:100px">
            <br>
            <h3 style="color:#16D39A"><?=$hospital2[0]->CONFIRMADO?></h3>
            <h4 style="color:#16D39A"><b>Diag. Confirmado</b></h4>    
        </div>
    </div>
    <div class="col-md-3">
        <div class="w3-card w3-hover-shadow w3-center" style="height:100px">
            <br>
            <h3 style="color:#E6C60D"><?=$hospital2[0]->SUSPEITO?></h3>
            <h4 style="color:#E6C60D"><b>Diag. Suspeito</b></h4>    
        </div>
    </div>
    <div class="col-md-3">
        <div class="w3-card w3-hover-shadow w3-center" style="height:100px">
            <br>
            <h3 style="color:#000000"><?=$hospital2[0]->UTI.' / '.$hospital2[0]->INTERNADO?></h3>
            <h4><b style="color:#FF0000">UTI</b> / <b style="color:#000000">Internados</b></h4>    
        </div>
    </div>
    <div class="col-md-3">
        <div class="w3-card w3-hover-shadow w3-center" style="height:100px">
            <br>
            <h3 style="color:#FF0000"><?=$hospital2[0]->UTI?></h3>
            <h4 style="color:#FF0000"><b>UTI</b></h4>    
        </div>
    </div>
    <div class="col-md-12"><br></div>
    <div class="col-md-12">
        <table class="table table-striped table-responsive datatable" id="datatable22s" cellpadding="0" cellspacing="0">
            <thead>
                <tr>
                    <th>Hospital</th>
                    <th>Paciente</th>
                    <th>Tipo</th>
                    <th>Grupo de Risco</th>
                    <th>Local</th>
                    <th>Ventilação Mec.</th>
                    <th>Teste Colhido</th>
                    <th>Cód. Teste</th>
                    <th>Observação</th>
                    <th>Data Cadastro</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($pacientes as $item): ?>
                <tr>
                    <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$item->nomefantasia?></td>
                    <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$item->carteiracpf?></td>
                    <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$item->tipo?></td>
                    <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$item->gruporisco?></td>
                    <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$item->local?></td>
                    <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$this->Custom->toSimNao($item->ventilacao)?></td>
                    <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$this->Custom->toSimNao($item->testecolhido)?></td>
                    <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$item->codigoteste?></td>
                    <td style="word-wrap: break-word;"><?=($item->observacao) ? $item->observacao : '-' ?></td>
                    <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$this->Custom->formatDataHora($item->datacadastro)?></td>
                </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<script>
    $('#datatable22s').DataTable( 
    {
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
            decimal: ",",
            thousands: "."
        },
        dom: 'Bfrtip',
                buttons: [
                {
                    extend: 'copy',
                    text: 'Copiar',
                    footer: true
                },
                {
                    extend: 'print',
                    text: 'Imprimir',
                    footer: true
                },
                {
                    extend: 'excel',
                    filename: 'FlyMed',
                    text: 'Excel',
                    footer: true
                },
                {
                    extend: 'pdf',
            //Name the pdf
            filename: 'FlyMed Resumo Hospital',
            text: 'PDF',
            orientation:'landscape',
            title:'',
            messageTop: 'Corps Teknologi - Analytics para Gestão Inteligente \n Emitido em: <?=Date('d/m/y H:i:s')?> \n Flymed - Unimed Natal',

            pageSize:'A4',
            footer: true
            }
            ],
    responsive: false,
    retrieve: false,
    paging : true,
    destroy: true,
    "pageLength":10,
    "scrollX" : true,
    fixedHeader: {
        header: false,
        footer: false
    },
    "initComplete": function() {
        window.dispatchEvent(new Event('resize'));
    }
    } 
    );
</script>