<div class="card">
    <div class="card-header">
        <div class="row">
            <div class="col-md-8">
                <p class="h3"><strong>Painel COVID</strong></p>
            </div>
            <div class="col-md-4">
                <p class="h6 float-right"><i><strong>Última Atualização: </strong><?=$this->Custom->formatData($data_ultima_atualizacao)?></i></p>
            </div>
        </div>
    </div>
    <div class="card-body">
        <div class="row">
            <div class="col-md-2">
                <div class="w3-card w3-hover-shadow w3-center" style="height:150px">
                    <div class="row">
                        <div class="col-md-12 mt-1">
                            <h4>Suspeitos</h4>
                            <h5><b><?=$this->Custom->toNumber($suspeitos[0]->suspeitos)?></b></h5>    
                        </div>
                        <div class="col-md-12">
                            <hr>
                        </div>
                        <div class="col-md-12">
                            <span>Internados</span> <br>
                            <span class="text-dark"><b><?=$this->Custom->toNumber($suspeitos[0]->internados)?></b></span>    
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="w3-card w3-hover-shadow w3-center" style="height:150px">
                    <div class="row">
                        <div class="col-md-12 mt-1">
                            <h4>Confirmados</h4>
                            <h5><b><?=$this->Custom->toNumber($confirmados[0]->confirmados)?></b></h5>
                        </div>
                        <div class="col-md-12">
                            <hr>
                        </div>
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-4">
                                    <span>Óbitos</span><br>
                                    <span class="text-danger"><b><?=$this->Custom->toNumber($confirmados[0]->obitos)?></b></span>
                                </div>
                                <div class="col-md-4">
                                    <span>Internados</span><br>
                                    <span class="text-warning"><b><?=$this->Custom->toNumber($confirmados[0]->internados)?></b></span>
                                </div>
                                <div class="col-md-4">
                                    <span>Alta</span><br>
                                    <span class="text-success"><b><?=$this->Custom->toNumber($confirmados[0]->recuperados)?></b></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-4">
                <div class="w3-card w3-hover-shadow w3-center" style="height:150px">
                    <div class="row">
                        <div class="col-md-12 mt-1">
                            <h4>Internados</h4>
                            <h5><b><?=$this->Custom->toNumber($internados[0]->internados)?></b></h5>
                        </div>
                        <div class="col-md-12">
                            <hr>
                        </div>
                        <div class="col-md-12">
                            <div class="row">
                                <div class="col-md-4">
                                    <span>UTI</span><br>
                                    <span class="text-danger"><b><?=$this->Custom->toNumber($internados[0]->uti)?></b></span>
                                </div>
                                <div class="col-md-4">
                                    <span>UCI</span><br>
                                    <span class="text-warning"><b><?=$this->Custom->toNumber($internados[0]->uci)?></b></span>
                                </div>
                                <div class="col-md-4">
                                    <span>Enfermaria</span><br>
                                    <span class="text-dark"><b><?=$this->Custom->toNumber($internados[0]->enfermaria)?></b></span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-2">
                <div class="w3-card w3-hover-shadow w3-center" style="height:150px">
                    <div class="row">
                        <div class="col-md-12 mt-1">
                            <h4>Descartados</h4>
                            <h5><b><?=$this->Custom->toNumber($descartados[0]->descartados)?></b></h5>
                        </div>
                        <div class="col-md-12">
                            <hr>
                        </div>
                        <div class="col-md-12">
                            <span>Internados</span><br>
                            <span class="text-warning"><b><?=$this->Custom->toNumber($descartados[0]->internados)?></b></span>
                        </div>
                    </div>
                </div>
            </div>
            <div class="col-md-12">
                <hr>
            </div>
            <div class="col-md-12">
                <table class="table table-responsive table-stripped datatable" id="datatable">
                    <thead>
                        <th>Hospital</th>
                        <th>UTI</th>
                        <th>Vent. Mecânica</th>
                        <th>UCI</th>
                        <th>Enfermaria</th>
                        <th>Total</th>
                        <th>Última Atualização</th>
                    </thead>
                    <tbody>
                    <?php foreach ($tabelahospitais as $item):?>
                        <tr>
                            <td><?=$item->hospital?></td>
                            <td><?=$item->uti?></td>
                            <td><?=$item->ventilacao?></td>
                            <td><?=$item->uci?></td>
                            <td><?=$item->enfermaria?></td>
                            <td><?=$item->total?></td>
                            <td><?=$this->Custom->formatData($item->data_ultima_atualizacao)?></td>
                        </tr>
                    <?php endforeach;?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>

$(document).ready(
        function() {
    $('#datatable').DataTable( 
    {
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
            decimal: ",",
            thousands: "."
        },
        dom: 'Bfrtip',
    responsive: false,
    retrieve: false,
    paging : true,
    destroy: true,
    "pageLength":10,
    "scrollX" : true,
    fixedHeader: {
        header: false,
        footer: false
    },
    "initComplete": function() {
        window.dispatchEvent(new Event('resize'));
    }
    } 
    );}
)
</script>