<div class="card">
    <div class="card-header">
        <h3>Título da Página</h3>
    </div>
    <div class="card-body">
        <h4>Body do card</h4>
        <div class="row mt-1">
            <div class="col-md-6">
                <strong>Grafico Pizza</strong>
                <div id="grapicopizza" style="height:300px"></div>
            </div>
            <div class="col-md-6">
                <strong>Grafico Barras</strong>
                <div id="grapicobarras" style="height:300px"></div>
            </div>
            <div class="col-md-6 mt-1">
                <strong>Grafico Linha</strong>
                <div id="grapicolinha" style="height:300px"></div>
            </div>
            <div class="col-md-6 mt-1">
                <strong>Datatable</strong>
                <table class="datatable table table-responsive table-stripped" id="datatable">
                    <thead>
                        <th>Estado</th>
                        <th>Total Municipios</th>
                    </thead>
                    <tbody>
                        <?php foreach($consulta as $item): ?>
                        <tr>
                            <td><?=$item->uf?></td>
                            <td><?=$item->totalcidades?></td>
                        </tr>
                        <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
</div>

<script>
$(document).ready(function(){
    $('#datatable').DataTable( 
    {
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
            decimal: ",",
            thousands: "."
        },
        dom: 'Bfrtip',
    destroy: true,
    responsive: false,
    retrieve: false,
    paging : true,
    "pageLength":5,
    "scrollX" : true,
    fixedHeader: {
        header: false,
        footer: false
    },
    "initComplete": function() {
        window.dispatchEvent(new Event('resize'));
    }
    } 
    );

    var myChart = echarts.init(document.getElementById('grapicobarras'));

    option = {
        tooltip: {
            trigger: 'axis',
        axisPointer: {
            type: 'shadow'
        }
    },
    legend: {
        data: ['Estados']
    },
    grid: {
        left: '3%',
        right: '4%',
        bottom: '3%',
        containLabel: true
    },
    xAxis: [
    {
        type: 'category',
        axisTick: {
            show: false
        },
        data: ['<?=implode("','",$estados);?>']
    }
    ],
    yAxis: [
    {
        type: 'value'
    }
    ],
    series: [
    {
        name: 'Total Municipios',
        type: 'bar',
        label: {
            show: true
        },
        data: [<?=implode(',',$municipios);?>]
    }
    ]
    };
    myChart.setOption(option);
    $(function () {
    $(window).on('resize', resize);
    $(".menu-toggle").on('click', resize);
    function resize() {
        setTimeout(function() {
            myChart.resize();
        }, 200);
    }
    });

    var myChart = echarts.init(document.getElementById('grapicopizza'));
    option = {
        tooltip: {
            trigger: 'item',
            formatter: '{a} <br/>{b} : {c} ({d}%)'
        },
        legend: {
            type: 'scroll',
            orient: 'vertical',
            right: 10,
            top: 20,
            bottom: 20,
            data: ['<?=implode("','",$estados);?>']
        },
        series: [
            {
                name: 'Total de Municipios',
                type: 'pie',
                radius: '55%',
                center: ['40%', '50%'],
                data: [
                    <?php foreach ($consulta as $item) : ?>
                        {value:<?=$item->totalcidades?>, name:'<?=$item->uf?>'},
                    <?php endforeach;?>
                    ],
                emphasis: {
                    itemStyle: {
                        shadowBlur: 10,
                        shadowOffsetX: 0,
                        shadowColor: 'rgba(0, 0, 0, 0.5)'
                    }
                }
            }
        ]
    };
    myChart.setOption(option);
    $(function () {
    $(window).on('resize', resize);
    $(".menu-toggle").on('click', resize);
    function resize() {
        setTimeout(function() {
            myChart.resize();
        }, 200);
    }
    });

    var myChart = echarts.init(document.getElementById('grapicolinha'));
    option = {
        xAxis: {
            type: 'category',
            data: ['Mon', 'Tue', 'Wed', 'Thu', 'Fri', 'Sat', 'Sun']
        },
        yAxis: {
            type: 'value'
        },
        series: [{
            data: [820, 932, 901, 934, 1290, 1330, 1320],
            type: 'line'
        }]
    };

    myChart.setOption(option);
    $(function () {
    $(window).on('resize', resize);
    $(".menu-toggle").on('click', resize);
    function resize() {
        setTimeout(function() {
            myChart.resize();
        }, 200);
    }
    });
})

</script>