
<div class="card">
    <div class="card-body">
        <div id="doughnutchart" class="height-400 echart-container" ></div>
    </div>
</div>

<script>
$(function () {
    var myChart = echarts.init(document.getElementById('doughnutchart'));
    option = {
        tooltip: {
            trigger: 'item',
            formatter: '{a} <br/>{b}: {c} ({d}%)'
        },
        series: [
            {
                name: 'Vendas',
                type: 'pie',
                selectedMode: 'single',
                radius: ['70%', '90%'],
                label: {
                    formatter: '{a|{a}}{abg|}\n{hr|}\n  {b|{b}：}{c}  {per|{d}%}  ',
                    backgroundColor: '#eee',
                    borderColor: '#aaa',
                    borderWidth: 1,
                    borderRadius: 4,
                    rich: {
                        a: {
                            color: '#999',
                            lineHeight: 22,
                            align: 'center'
                        },
                        hr: {
                            borderColor: '#aaa',
                            width: '100%',
                            borderWidth: 0.5,
                            height: 0
                        },
                        b: {
                            fontSize: 16,
                            lineHeight: 33
                        },
                        per: {
                            color: '#eee',
                            backgroundColor: '#334455',
                            padding: [2, 4],
                            borderRadius: 2
                        }
                    }
                },
                data: [
                    {value: 1, name: 'ACOUGUE'},
                    {value: 2, name: 'BAZAR'},
                    {value: 3, name: 'DPH'},
                    {value: 4, name: 'FLV'},
                    {value: 5, name: 'FRIOS'}
                ]
            }
        ]
    };
    myChart.setOption(option);


    // Resize chart
    // ------------------------------

    $(function () {

        // Resize chart on menu width change and window resize
        $(window).on('resize', resize);
        $(".menu-toggle").on('click', resize);

        // Resize function
        function resize() {
            setTimeout(function() {

                // Resize chart
                myChart.resize();
            }, 200);
        }
    });
});
</script>