<?php
	$session = $this->request->session();
	$idperfil = $session->read('login.usuario')->idperfil;
	
	$mesMenos1 = (object)[
		'mes'=>$mesAtual-1
		,'ano'=>$anoAtual
	];
	$mesMenos2 = (object)[
		'mes'=>$mesAtual-2
		,'ano'=>$anoAtual
	];
	if($mesAtual == 1){
		$mesMenos1->mes = 12;
		$mesMenos1->ano = $anoAtual-1;
		
		$mesMenos2->mes = 11;
		$mesMenos2->ano = $anoAtual-1;
	}
	if($mesAtual == 2){
		$mesMenos1->mes = 1;
		$mesMenos1->ano = $anoAtual;
		
		$mesMenos2->mes = 12;
		$mesMenos2->ano = $anoAtual-1;
	}
	$comissao = 0;
	foreach ($resumo as $item){
		$comissao += $item->COMISSAO;
	}
?>
<h3>Equipes</h3>
<div class="row">
	<div class="col-md-12">
		<div class="card">
			<div class="card-body text-center">
				<br>
				<h3 class="display-6 primary darken-1">Visão Geral</h3>
				<div class="row text-center">
					<div class="col-md-6">
						<h3 class="display-6 success darken-1">Total de Equipes</h3>
						<h2><?=$this->Custom->toNumber(count($resumo))?></h2>
					</div>
					<div class="col-md-6">
						<h3 class="display-6 success darken-1">Comissão Total</h3>
						<h2><?=$this->Custom->toFloat($comissao)?></h2>
					</div>
				</div>
			</div>
		</div>
	</div>
</div>
<br>
<div class="row">
	<div class="col-md-6">
		<div class="card">
			<div class="card-body">
				<h3 class="text-center">Comissionamento por Mês e Ano dos Últimos 3 anos</h3><br>
				<div id="comissaopormeseano" style="margin-top:2%" class="height-400 echart-container"></div>    
			</div>
		</div>
	</div>	
	<div class="col-md-6">
		<div class="card">
			<div class="card-body">
				<h3 class="text-center">Comissionamento Acumulado por Mês e Ano dos Últimos 3 anos</h3><br>
				<div id="comissaopormeseanoacum" style="margin-top:2%" class="height-400 echart-container"></div>    
			</div>
		</div>
	</div>					
	<div class="col-md-12">
		<div class="card">
			<div class="card-body">
				<h3 class="text-center">Demonstrativo de comissionamento por ano</h3><br>
				<div id="comissaoporano" style="margin-top:2%" class="height-400 echart-container"></div>    
			</div>
		</div>
	</div>					
</div>
<div class="row">
	<div class="col-md-12">
		<div class="card">
			<div class="card-body">
				<h3 class="text-center">Relação de Equipes</h3><br>
				<table class="table table-striped  datatable" id="datatable" >
					<thead>
						<tr>
							<th>Equipe</th>
							<th>Agentes <br> total</th>
							<th>Beneficiários <br> total</th>
							<th>Beneficiários Distintos<br> total</th>
							<th>Proporção <br> %</th>
							<th>Diferença </th>
							<th>Ativos </th>
							<th>Proporção <br> % </th>
							<th>Comissão <br> R$</th>
							<th>Comissão / Benef.<br> R$/Beneficiário</th>
						</tr>
					</thead>
					<tbody>
					<?php foreach ($resumo as $item): ?>
						<tr style="cursor:pointer" onclick="window.location.href='equipe/view/<?=$item->COD_EQUIPE?>/<?=$item->EQUIPE?>'">
							<td><?=$item->EQUIPE?></td>
							<td><?=$this->Custom->toNumber($item->AGENTES)?></td>
							<td><?=$this->Custom->toNumber($item->BENEFICIARIOS)?></td>
							<td><?=$this->Custom->toNumber($item->BENEFICIARIOSDISTINTOS)?></td>
							<td><?=$this->Custom->toFloat($item->BENEFICIARIOSDISTINTOS*100/$item->BENEFICIARIOS)?></td>
							<td><?=$this->Custom->toNumber($item->BENEFICIARIOS - $item->BENEFICIARIOSDISTINTOS)?></td>
							<td><?=$this->Custom->toNumber($item->ATIVOS)?></td>
							<td><?=$this->Custom->toFloat($item->ATIVOS*100/(($item->BENEFICIARIOSDISTINTOS == 0) ? 1 : $item->BENEFICIARIOSDISTINTOS)  )?></td>
							<td><?=$this->Custom->toFloat($item->COMISSAO)?></td>
							<td><?=$this->Custom->toFloat($item->COMISSAO/$item->BENEFICIARIOSDISTINTOS)?></td>
						</tr>
					<?php endforeach; ?>
					</tbody>
					<tfoot>
						<tr>
							<th>Total</th>
							<th></th>
							<th></th>
							<th></th>
							<th></th>
							<th></th>
							<th></th>
							<th></th>
							<th></th>
							<th></th>
						</tr> 
					</tfoot>
				</table>
			</div>
		</div>
	</div>					
</div>



<script>

var myChart = echarts.init(document.getElementById('comissaopormeseanoacum'));

option = {
    tooltip: {
        trigger: 'axis',
        axisPointer: {
            type: 'cross',
            crossStyle: {
                color: '#999'
            }
        }
    },
    legend: {
        data:[<?='\''.Date('Y').'\''.','.'\''.(Date('Y')-1).'\''.','.'\''.(Date('Y')-2).'\''?>,'Média dos 3 anos anteriores']
    },
    xAxis: [
        {
            type: 'category',
            axisTick: {show: false},
            data: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez']
        }
    ],
    yAxis: {
        axisLine: {
            show: false
        },
        axisTick: {
            show: true
        },
        axisLabel: {
            textStyle: {
                color: '#000'
            }
        }
    },
    color: ['#F98E76', '#16D39A', '#2DCEE3','#000000'],
    dataZoom: [
        {
            type: 'inside'
        }
    ],/*
    series: [
        {
            type: 'bar',
            data: data
        }
    ]*/
    series: [
        {
            name: '<?=Date('Y')-2?>',
            type: 'line',
            data: <?php echo ('['.$acumanom2[0]->total.','.$acumanom2[1]->total.','.$acumanom2[2]->total.','.$acumanom2[3]->total.','.$acumanom2[4]->total.','.$acumanom2[5]->total.','.$acumanom2[6]->total.','.$acumanom2[7]->total.','.$acumanom2[8]->total.','.$acumanom2[9]->total.','.$acumanom2[10]->total.','.$acumanom2[11]->total.']');?>
        },
        {
            name: '<?=Date('Y')-1?>',
            type: 'line',
            data: <?php echo ('['.$acumanom1[0]->total.','.$acumanom1[1]->total.','.$acumanom1[2]->total.','.$acumanom1[3]->total.','.$acumanom1[4]->total.','.$acumanom1[5]->total.','.$acumanom1[6]->total.','.$acumanom1[7]->total.','.$acumanom1[8]->total.','.$acumanom1[9]->total.','.$acumanom1[10]->total.','.$acumanom1[11]->total.']');?>
        },
        {
            name: '<?=Date('Y')?>',
            type: 'line',
            data: <?php echo ('['.$acumanoatual[0]->total.','.$acumanoatual[1]->total.','.$acumanoatual[2]->total.','.$acumanoatual[3]->total.','.$acumanoatual[4]->total.','.$acumanoatual[5]->total.','.$acumanoatual[6]->total.','.$acumanoatual[7]->total.','.$acumanoatual[8]->total.','.$acumanoatual[9]->total.','.$acumanoatual[10]->total.','.$acumanoatual[11]->total.']');?>
        },
        {
            name: 'Média dos 3 anos anteriores',
            type: 'line',
            data: <?php echo ('['.$acummedia[0].','.$acummedia[1].','.$acummedia[2].','.$acummedia[3].','.$acummedia[4].','.$acummedia[5].','.$acummedia[6].','.$acummedia[7].','.$acummedia[8].','.$acummedia[9].','.$acummedia[10].','.$acummedia[11].']');?>
        }
    ]
};

myChart.setOption(option);
    myChart.resize();

    // Resize chart
    // ------------------------------

    $(function () {

        // Resize chart on menu width change and window resize
        $(window).on('resize', resize);
        $(".menu-toggle").on('click', resize);

        // Resize function
        function resize() {
            setTimeout(function() {

                // Resize chart
                myChart.resize();
            }, 200);
        }
    });
</script>




<script>

var myChart2 = echarts.init(document.getElementById('comissaopormeseano'));

option = {
    tooltip: {
        trigger: 'axis',
        axisPointer: {
            type: 'cross',
            crossStyle: {
                color: '#999'
            }
        }
    },
    legend: {
        data:[<?='\''.Date('Y').'\''.','.'\''.(Date('Y')-1).'\''.','.'\''.(Date('Y')-2).'\''?>,'Média dos 3 anos anteriores']
    },
    xAxis: [
        {
            type: 'category',
            axisTick: {show: false},
            data: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez']
        }
    ],
    yAxis: {
        axisLine: {
            show: false
        },
        axisTick: {
            show: true
        },
        axisLabel: {
            textStyle: {
                color: '#000'
            }
        }
    },
    color: ['#F98E76', '#16D39A', '#2DCEE3','#000000'],
    dataZoom: [
        {
            type: 'inside'
        }
    ],/*
    series: [
        {
            type: 'bar',
            data: data
        }
    ]*/
    series: [
        {
            name: '<?=Date('Y')-2?>',
            type: 'line',
            data: <?php echo ('['.$graficoanom2[0]->total.','.$graficoanom2[1]->total.','.$graficoanom2[2]->total.','.$graficoanom2[3]->total.','.$graficoanom2[4]->total.','.$graficoanom2[5]->total.','.$graficoanom2[6]->total.','.$graficoanom2[7]->total.','.$graficoanom2[8]->total.','.$graficoanom2[9]->total.','.$graficoanom2[10]->total.','.$graficoanom2[11]->total.']');?>
        },
        {
            name: '<?=Date('Y')-1?>',
            type: 'line',
            data: <?php echo ('['.$graficoanom1[0]->total.','.$graficoanom1[1]->total.','.$graficoanom1[2]->total.','.$graficoanom1[3]->total.','.$graficoanom1[4]->total.','.$graficoanom1[5]->total.','.$graficoanom1[6]->total.','.$graficoanom1[7]->total.','.$graficoanom1[8]->total.','.$graficoanom1[9]->total.','.$graficoanom1[10]->total.','.$graficoanom1[11]->total.']');?>
        },
        {
            name: '<?=Date('Y')?>',
            type: 'line',
            data: <?php echo ('['.$graficoanoatual[0]->total.','.$graficoanoatual[1]->total.','.$graficoanoatual[2]->total.','.$graficoanoatual[3]->total.','.$graficoanoatual[4]->total.','.$graficoanoatual[5]->total.','.$graficoanoatual[6]->total.','.$graficoanoatual[7]->total.','.$graficoanoatual[8]->total.','.$graficoanoatual[9]->total.','.$graficoanoatual[10]->total.','.$graficoanoatual[11]->total.']');?>
        },
        {
            name: 'Média dos 3 anos anteriores',
            type: 'line',
            data: <?php echo ('['.$media[0].','.$media[1].','.$media[2].','.$media[3].','.$media[4].','.$media[5].','.$media[6].','.$media[7].','.$media[8].','.$media[9].','.$media[10].','.$media[11].']');?>
        }
    ]
};

myChart2.setOption(option);
    myChart2.resize();

    // Resize chart
    // ------------------------------

    $(function () {

        // Resize chart on menu width change and window resize
        $(window).on('resize', resize);
        $(".menu-toggle").on('click', resize);

        // Resize function
        function resize() {
            setTimeout(function() {

                // Resize chart
                myChart2.resize();
            }, 200);
        }
    });
</script>


<script>

$(document).ready(
        function() {
            $('#datatable').DataTable( 
            {
                language: {
                    url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                    decimal: ",",
                    thousands: "."
                },
                dom: 'Bfrtip',
                buttons: [
                {
                    extend: 'copy',
                    text: 'Copiar',
                    footer: true
                },
                {
                    extend: 'print',
                    text: 'Imprimir',
                    footer: true
                },
                {
                    extend: 'excel',
                    filename: 'FlyMed',
                    text: 'Excel',
                    footer: true,
					exportOptions: {
						columns: ':visible',
						format: {
							body: function(data, row, column, node) {
								if ([4,7].includes(column)){
									data = $('<p>' + data + '</p>').text();
									return $.isNumeric(data.replace(',', '.')) ? data.replace(',', '.') : data;
								} else {
									return data;
								} 
							}
						}
     				}
                },
                {
                    extend: 'pdf',
            //Name the pdf
            filename: 'FlyMed Relação de Equipes',
            text: 'PDF',
            orientation:'portrait',
            title:'FlyMed Relação de Equipes',
            pageSize:'A2',
            footer: true
            }
            ],
            responsive: false,
            retrieve: false,
            "footerCallback": function ( row, data, start, end, display ) {
                var totalcolums = [1,2,3,6,8];

                var api = this.api(), data;
                // Remove the formatting to get integer data for summation
                var intVal = function (i) {
                    if(typeof i === 'string'){
                        i = i.toString();
                        i = i.replace('<span style=\"color:red\">', '');
                        i = i.replace('</span>', '');
                    }

                    return typeof i === 'string' ?
                    i.replace(/\./g, '').replace(/\,/g, '.') * 1 :
                    typeof i === 'number' ?
                    i : 0;
                };

                for(i=0;i<totalcolums.length;i++){
                    var col = api .column( totalcolums[i], {filter:'applied'} ).data().reduce( function (a, b) {return intVal(a) + intVal(b);}, 0 );
                    col = col.toLocaleString('pt-BR');
                    col = col < 0 ? '<span style=\"color:red\">'+col+'</span>' : col;
                    $( api.column( totalcolums[i] ).footer() ).html(col);
                }
            },
            paging : true,
            "pageLength":50,
            "order": [[ 1, "desc" ]],
            "scrollX" : true,
			fixedColumns:{
				leftColumn : 1
			},
            fixedHeader: {
                header: false,
                footer: false
            },
			"initComplete": function() {
				window.dispatchEvent(new Event('resize'));
  			}
            } 
            );}
        );
</script>



<script>
var myChartbar = echarts.init(document.getElementById('comissaoporano'));
var yMax = 80;
option = {
    tooltip: {
        trigger: 'axis',
        axisPointer: {
            type: 'cross',
            crossStyle: {
                color: '#999'
            }
        }
    },
    xAxis: [
        {
            type: 'category',
            axisTick: {show: false},
            data:[<?php $counta = 0; foreach($comissaoporano as $ano){   $counta ++; $comma = ($counta == count($comissaoporano)) ? '' : ','; echo ('\''.$ano->ANO.'\''.$comma); } ?>]
        }
    ],
    yAxis: {
        axisLine: {
            show: false
        },
        axisTick: {
            show: true
        },
        axisLabel: {
            textStyle: {
                color: '#000'
            }
        }
    },
    dataZoom: [
        {
            type: 'inside'
        }
    ],/*
    series: [
        {
            type: 'bar',
            data: data
        }
    ]*/
    series: [
        {
            name: 'Total do Ano',
            type: 'bar',
            barGap: 0,
            data: [<?php $counta = 0; foreach($comissaoporano as $ano){   $counta ++; $comma = ($counta == count($comissaoporano)) ? '' : ','; echo ('\''.$ano->TOTAL.'\''.$comma); } ?>]
        },
        {
            name: 'Média',
            type: 'line',
            data: [<?php $counta = 0; foreach($comissaoporano as $ano){   $counta ++; $comma = ($counta == count($comissaoporano)) ? '' : ','; echo ('\''.$mediabar.'\''.$comma); } ?>]
        }
    ]
};

myChartbar.setOption(option);
    myChartbar.resize();

    // Resize chart
    // ------------------------------

    $(function () {

        // Resize chart on menu width change and window resize
        $(window).on('resize', resize);
        $(".menu-toggle").on('click', resize);

        // Resize function
        function resize() {
            setTimeout(function() {

                // Resize chart
                myChartbar.resize();
            }, 200);
        }
    });
</script>