<?php 
    $session = $this->request->session();
    $empresa = $session->read('login.empresa')->nome;
?>

<h3>Equipe <?=$id?> (<?=$nomeequipe?>)</h3>

<div class="row">
	<div class="col-md-6 col-12" style="margin-top:1%">
		<div class="card h-100 profile-card-with-stats border-teal border-lighten-2">
			<div class="text-center">
				<div class="card-body">
					<img src="../../../../webroot/users.png" class="rounded-circle  height-150" alt="Card image">
				</div>
				<div class="card-body">
					<h4 class="card-title"><?=$nomeequipe?></h4>
				</div>
				<div class="card-body" style="text-align:left">
				    <h3>Dados da Equipe:</h3>
					<div class="row">
                        <div class="col-md-12">
                        </div>
                        <div class="col-md-4">
							<b>Total Comissionado:</b> <p><?=$this->Custom->toMoney($comissaototal)?></p>      
							<b>Beneficiários Ativos:</b> <p><?=$this->Custom->toNumber($ativos[0]->ATIVOS)?></p>      
                        </div>
                        <div class="col-md-4">
							<b>Número de Agentes:</b> <p><?=$this->Custom->toNumber($agentes[0]->AGENTES)?></p>  
							<b>Comissão / Beneficiário:</b> <p><?=$this->Custom->toMoney($comissaototal/$beneficiarios[0]->DISTINTOS)?></p>      
                        </div>
                        <div class="col-md-4">
							<b>N° Beneficiários:</b> <p><?=$this->Custom->toNumber($beneficiarios[0]->BENEFICIARIOS)?></p>  
							<b>N° Beneficiários Distintos:</b> <p><?=$this->Custom->toNumber($beneficiarios[0]->DISTINTOS)?></p>         
                        </div>
					</div>
				</div>
			</div>
		</div>
	</div>
	<div class="col-md-6 col-12" style="margin-top:1%">
		<div class="card h-100">
            <div class="card-content">
                <div class="card-body">
                    <div class="row">
                        <div class="col-lg-12 col-sm-12 border-right-blue-grey border-right-lighten-5" style="margin-top:4%">
                            <div class="pb-1">
                                <div class="clearfix mb-1">
                                    <i class="icon-check font-large-1 warning float-left mt-1"></i>
                                    <span class="font-large-1 text-bold-300 warning float-right"><?=$this->Custom->toMoney($comissaototal)?></span>
                                </div>
                                <div class="clearfix">
                                    <span class="font-medium-2 text-bold-1000">Comissão Total</span>
                                </div>
                            </div>
                        <hr>
                        </div>
                        <div class="col-lg-12 col-sm-12 border-right-blue-grey border-right-lighten-5" style="margin-top:5%">
                            <div class="pb-1">
                                <div class="clearfix mb-1">
                                    <i class="fa fa-handshake-o font-large-1 info float-left mt-1"></i>
                                    <span class="font-large-1 text-bold-300 info float-right"><?=$this->Custom->toNumber($resumoequipe->CONTRATOS)?>
									</span>
                                </div>
                                <div class="clearfix">
                                    <span class="font-medium-2 text-bold-1000 ">Total de Contratos</span>
                                </div>
                            </div>
                            <hr>
                        </div>
                        <div class="col-lg-12 col-sm-12 border-right-blue-grey border-right-lighten-5" style="margin-top:5%">
                            <div class="pb-1">
                                <div class="clearfix mb-1">
                                    <i class="icon-check font-large-1 success float-left mt-1"></i>
                                    <span class="font-large-1 text-bold-300 success float-right"><?=$this->Custom->toNumber($ativos[0]->ATIVOS)?></span>
                                </div>
                                <div class="clearfix">
                                    <span class="font-medium-2 text-bold-1000">Beneficiários Ativos</span></i> 
                                        
                                    <span class="darken-1 float-right success"> de <b> <?=$this->Custom->toNumber($beneficiarios[0]->DISTINTOS)?></b> beneficiários distintos
                                    </span>
                                </div>
                            </div>
                            <div class="progress mb-0" style="height: 7px;">
                                <div class="progress-bar bg-success" role="progressbar" style="width: <?=$ativos[0]->ATIVOS*100/$beneficiarios[0]->DISTINTOS?>%" aria-valuenow="<?=$ativos[0]->ATIVOS*100/$beneficiarios[0]->DISTINTOS?>" aria-valuemin="0" aria-valuemax="100"></div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
	</div>
    <div class="col-xl-6 col-md-12" style="margin-top:1%">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        <b>Relação de Beneficiários novos por mês e ano dos últimos 3 anos</b>
                        <div id="consumovspag" style="margin-top:2%" class="height-500 echart-container"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-xl-6 col-md-12" style="margin-top:1%">
        <div class="card">
            <div class="card-body">
                <div class="row">
                    <div class="col-md-12">
                        <b>Relação acumulada de Beneficiários novos por mês e ano dos últimos 3 anos</b>
                        <div id="consumovspagacum" style="margin-top:2%" class="height-500 echart-container"></div>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <div class="col-md-12" style="margin-top:1%">
        <div class="card">
            <div class="card-content">
                <div class="card-body">
                    <ul class="nav nav-tabs nav-top-border no-hover-bg nav-justified">
                        <li class="nav-item">
                            <a class="nav-link active" id="" data-toggle="tab" href="#agentes" aria-controls="agentes" aria-expanded="true">
                                Agentes
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="" data-toggle="tab" href="#produtos" aria-controls="produtos" aria-expanded="true">
                                Produtos
                            </a>
                        </li>
                        <li class="nav-item">
                            <a class="nav-link" id="" data-toggle="tab" href="#beneficiarios" aria-controls="beneficiarios" aria-expanded="true">
                                Beneficiários
                            </a>
                        </li>
                    </ul>
                    <div class="tab-content px-1 pt-1" style="width:100%">
                        <div role="tabpanel" class="tab-pane active" id="agentes" aria-labelledby="agentes" aria-expanded="true">
                            <h3 class="text-center">Relação de Agentes</h3><br>
                            <table class="table table-striped table-responsive datatable" id="datatable" style="text-align:center">
                                <thead>
                                    <tr>
                                        <th>Agente</th>
                                        <th>Cód. Agente</th>
                                        <th>Beneficiários</th>
                                        <th>Beneficiários Distintos</th>
                                        <th>Proporção<br>%</th>
                                        <th>Diferença</th>
                                        <th>Comissão<br>R$</th>
                                        <th>Comissão / Benef.<br>R$</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($resumoagentes as $item): ?>
                                    <tr>
                                        <td><?=$item->NOME_AGENTE?></td>
                                        <td><?=$item->COD_AGENTE?></td>
                                        <td><?=$this->Custom->toNumber($item->TOTAL)?></td>
                                        <td><?=$this->Custom->toNumber($item->DISTINTOS)?></td>
                                        <td><?=$this->Custom->toFloat($item->DISTINTOS*100/$item->TOTAL)?></td>
                                        <td><?=$this->Custom->toNumber($item->TOTAL - $item->DISTINTOS)?></td>
                                        <td><?=$this->Custom->toFloat($item->COMISSAO)?></td>
                                        <td><?=$this->Custom->toFloat($item->COMISSAO/$item->DISTINTOS)?></td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>Total</th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                    </tr> 
                                </tfoot>
                            </table>
                        </div>
                        <div role="tabpanel" class="tab-pane fade" id="produtos" aria-labelledby="produtos" aria-expanded="true">
                            <h3 class="text-center">Relação de Produtos Ativos por Faixa Etária</h3><br>
                            <table class="table table-striped table-responsive datatable" id="produtostable" style="text-align:center">
                                <thead>
                                    <tr>
                                        <th style="width:100%">Produto</th>
                                        <th>0-18</th>
                                        <th>19-23</th>
                                        <th>24-28</th>
                                        <th>29-33</th>
                                        <th>34-38</th>
                                        <th>39-43</th>
                                        <th>44-48</th>
                                        <th>49-53</th>
                                        <th>54-58</th>
                                        <th>59-200</th>
                                        <th>Total</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($produtos as $item): ?>
                                    <tr>
                                        <td style="width:100%"><?=$item->NOME_PERFIL?></td>
                                        <td><?=$this->Custom->toNumber($item->{'0-18'})?></td>
                                        <td><?=$this->Custom->toNumber($item->{'19-23'})?></td>
                                        <td><?=$this->Custom->toNumber($item->{'24-28'})?></td>
                                        <td><?=$this->Custom->toNumber($item->{'29-33'})?></td>
                                        <td><?=$this->Custom->toNumber($item->{'34-38'})?></td>
                                        <td><?=$this->Custom->toNumber($item->{'39-43'})?></td>
                                        <td><?=$this->Custom->toNumber($item->{'44-48'})?></td>
                                        <td><?=$this->Custom->toNumber($item->{'49-53'})?></td>
                                        <td><?=$this->Custom->toNumber($item->{'54-58'})?></td>
                                        <td><?=$this->Custom->toNumber($item->{'59-200'})?></td>
                                        <td><?=$this->Custom->toNumber($item->{'0-18'} + $item->{'19-23'}+ $item->{'24-28'}+ $item->{'29-33'}+ $item->{'34-38'}+ $item->{'39-43'}+ $item->{'44-48'}+ $item->{'49-53'}+ $item->{'54-58'}+ $item->{'59-200'})?></td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>Total</th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                        <th></th>
                                    </tr> 
                                </tfoot>
                            </table>
                        </div>
                        <div role="tabpanel" class="tab-pane fade" id="beneficiarios" aria-labelledby="beneficiarios" aria-expanded="true">
                            <h3 class="text-center">Relação de Beneficiários Ativos da Equipe</h3><br>
                            <table class="table table-striped table-responsive datatable" id="beneficiariostable" style="text-align:center">
                                <thead>
                                    <tr>
                                        <th>Cód Beneficiario</th>
                                        <th>Comissão<br>R$</th>
                                    </tr>
                                </thead>
                                <tbody>
                                <?php foreach ($beneficiariosequipe as $item): ?>
                                    <tr style="cursor:pointer" onclick="window.location.href='../../../beneficiario/pessoa/<?=$item->COD_BENEFICIARIO?>'">
                                        <td><?=$item->COD_BENEFICIARIO?></td>
                                        <td><?=$this->Custom->toFloat($item->COMISSAO)?></td>
                                    </tr>
                                <?php endforeach; ?>
                                </tbody>
                                <tfoot>
                                    <tr>
                                        <th>Total</th>
                                        <th></th>
                                    </tr> 
                                </tfoot>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<script>
$(document).ready(
        function() {
            $('#datatable').DataTable( 
            {
                language: {
                    url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                    decimal: ",",
                    thousands: "."
                },
                dom: 'Bfrtip',
                buttons: [
                {
                    extend: 'copy',
                    text: 'Copiar',
                    footer: true
                },
                {
                    extend: 'print',
                    text: 'Imprimir',
                    footer: true
                },
                {
                    extend: 'excel',
                    filename: 'FlyMed',
                    text: 'Excel',
                    footer: true,
					exportOptions: {
						columns: ':visible',
						format: {
							body: function(data, row, column, node) {
								if ([4,7].includes(column)){
									data = $('<p>' + data + '</p>').text();
									return $.isNumeric(data.replace(',', '.')) ? data.replace(',', '.') : data;
								} else {
									return data;
								} 
							}
						}
     				}
                },
                {
                    extend: 'pdf',
                    //Name the pdf
                    filename: 'FlyMed Relação de Agentes',
                    text: 'PDF',
                    orientation:'portrait',
                    title:'FlyMed Relação de Agentes',
                    pageSize:'A2',
                    footer: true,
                    exportOptions: {
                        stripNewlines: false,
                        format: {
                            header: function ( text, index, node ) {
                                return text.includes("<br>") ?
                                    text.replace( '<br>', '\n' ) :
                                    text;
                            }
                        }
                    }
                }
            ],
            responsive: false,
            retrieve: false,
            "footerCallback": function ( row, data, start, end, display ) {
                var totalcolums = [2,6];

                var api = this.api(), data;
                // Remove the formatting to get integer data for summation
                var intVal = function (i) {
                    if(typeof i === 'string'){
                        i = i.toString();
                        i = i.replace('<span style=\"color:red\">', '');
                        i = i.replace('</span>', '');
                    }

                    return typeof i === 'string' ?
                    i.replace(/\./g, '').replace(/\,/g, '.') * 1 :
                    typeof i === 'number' ?
                    i : 0;
                };

                for(i=0;i<totalcolums.length;i++){
                    var col = api .column( totalcolums[i], {filter:'applied'} ).data().reduce( function (a, b) {return intVal(a) + intVal(b);}, 0 );
                    col = col.toLocaleString('pt-BR');
                    col = col < 0 ? '<span style=\"color:red\">'+col+'</span>' : col;
                    $( api.column( totalcolums[i] ).footer() ).html(col);
                }
            },
            paging : true,
            "pageLength":10,
            "order": [[ 1, "desc" ]],
			fixedColumns:{
				leftColumn : 1
			},
            fixedHeader: {
                header: false,
                footer: false
            },
			"initComplete": function() {
				window.dispatchEvent(new Event('resize'));
  			}
            } 
            );}
        );
$(document).ready(
        function() {
            $('#produtostable').DataTable( 
            {
                language: {
                    url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                    decimal: ",",
                    thousands: "."
                },
                dom: 'Bfrtip',
                buttons: [
                {
                    extend: 'copy',
                    text: 'Copiar',
                    footer: true
                },
                {
                    extend: 'print',
                    text: 'Imprimir',
                    footer: true
                },
                {
                    extend: 'excel',
                    filename: 'FlyMed',
                    text: 'Excel',
                    footer: true
                },
                {
                    extend: 'pdf',
                    //Name the pdf
                    filename: 'FlyMed Relação de Produtos por Faixa Etária',
                    text: 'PDF',
                    orientation:'portrait',
                    title:'FlyMed Relação de Produtos por Faixa Etária',
                    pageSize:'A4',
                    customize: function(doc) {
                        doc.styles.tableBodyEven.alignment = 'center';
                        doc.styles.tableBodyOdd.alignment = 'center'; 
                    },      
                    footer: true,
                    exportOptions: {
                        stripNewlines: false,
                        format: {
                            header: function ( text, index, node ) {
                                return text.includes("<br>") ?
                                    text.replace( '<br>', '\n' ) :
                                    text;
                            }
                        }
                    }
                }
            ],
            responsive: false,
            retrieve: false,
            "footerCallback": function ( row, data, start, end, display ) {
                var totalcolums = [1,2,3,4,5,6,7,8,9,10,11];

                var api = this.api(), data;
                // Remove the formatting to get integer data for summation
                var intVal = function (i) {
                    if(typeof i === 'string'){
                        i = i.toString();
                        i = i.replace('<span style=\"color:red\">', '');
                        i = i.replace('</span>', '');
                    }

                    return typeof i === 'string' ?
                    i.replace(/\./g, '').replace(/\,/g, '.') * 1 :
                    typeof i === 'number' ?
                    i : 0;
                };

                for(i=0;i<totalcolums.length;i++){
                    var col = api .column( totalcolums[i], {filter:'applied'} ).data().reduce( function (a, b) {return intVal(a) + intVal(b);}, 0 );
                    col = col.toLocaleString('pt-BR');
                    col = col < 0 ? '<span style=\"color:red\">'+col+'</span>' : col;
                    $( api.column( totalcolums[i] ).footer() ).html(col);
                }
            },
            paging : true,
            "pageLength":10,
            "order": [[ 11, "desc" ]],
			fixedColumns:{
				leftColumn : 1
			},
            fixedHeader: {
                header: false,
                footer: false
            },
			"initComplete": function() {
				window.dispatchEvent(new Event('resize'));
  			}
            } 
            );}
        );
$(document).ready(
        function() {
            $('#beneficiariostable').DataTable( 
            {
                language: {
                    url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
                    decimal: ",",
                    thousands: "."
                },
                dom: 'Bfrtip',
                buttons: [
                {
                    extend: 'copy',
                    text: 'Copiar',
                    footer: true
                },
                {
                    extend: 'print',
                    text: 'Imprimir',
                    footer: true
                },
                {
                    extend: 'excel',
                    filename: 'FlyMed',
                    text: 'Excel',
                    footer: true,
					exportOptions: {
						columns: ':visible',
						format: {
							body: function(data, row, column, node) {
								if ([4,7].includes(column)){
									data = $('<p>' + data + '</p>').text();
									return $.isNumeric(data.replace(',', '.')) ? data.replace(',', '.') : data;
								} else {
									return data;
								} 
							}
						}
     				}
                },
                {
                    extend: 'pdf',
                    //Name the pdf
                    filename: 'FlyMed Relação de Agentes',
                    text: 'PDF',
                    orientation:'portrait',
                    title:'FlyMed Relação de Agentes',
                    pageSize:'A2',
                    footer: true,
                    exportOptions: {
                        stripNewlines: false,
                        format: {
                            header: function ( text, index, node ) {
                                return text.includes("<br>") ?
                                    text.replace( '<br>', '\n' ) :
                                    text;
                            }
                        }
                    }
                }
            ],
            responsive: false,
            retrieve: false,    /*
            "processing": true,
            "serverSide": true,
            "ajax": "../../../../webroot/serversideoracle.php", */
            "footerCallback": function ( row, data, start, end, display ) {
                var totalcolums = [1];

                var api = this.api(), data;
                // Remove the formatting to get integer data for summation
                var intVal = function (i) {
                    if(typeof i === 'string'){
                        i = i.toString();
                        i = i.replace('<span style=\"color:red\">', '');
                        i = i.replace('</span>', '');
                    }

                    return typeof i === 'string' ?
                    i.replace(/\./g, '').replace(/\,/g, '.') * 1 :
                    typeof i === 'number' ?
                    i : 0;
                };

                for(i=0;i<totalcolums.length;i++){
                    var col = api .column( totalcolums[i], {filter:'applied'} ).data().reduce( function (a, b) {return intVal(a) + intVal(b);}, 0 );
                    col = col.toLocaleString('pt-BR');
                    col = col < 0 ? '<span style=\"color:red\">'+col+'</span>' : col;
                    $( api.column( totalcolums[i] ).footer() ).html(col);
                }
            },
            paging : true,
            "pageLength":10,
            "order": [[ 1, "desc" ]],
			fixedColumns:{
				leftColumn : 1
			},
            fixedHeader: {
                header: false,
                footer: false
            },
			"initComplete": function() {
				window.dispatchEvent(new Event('resize'));
  			}
            } 
            );}
        );
</script>


<script>
var myChart2 = echarts.init(document.getElementById('consumovspag'));

option = {
    tooltip: {
        trigger: 'axis',
        axisPointer: {
            type: 'cross',
            crossStyle: {
                color: '#999'
            }
        }
    },
    legend: {
        data:[<?='\''.Date('Y').'\''.','.'\''.(Date('Y')-1).'\''.','.'\''.(Date('Y')-2).'\''?>,'Média']
    },
    xAxis: [
        {
            type: 'category',
            axisTick: {show: false},
            data: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez']
        }
    ],
    yAxis: [{
        axisLine: {
            show: false
        },
        axisTick: {
            show: true
        },
        axisLabel: {
            textStyle: {
                color: '#000'
            },
            formatter: '{value}'
        }
    }],
    color: ['#F98E76', '#16D39A', '#2DCEE3','#000000'],
    dataZoom: [
        {
            type: 'inside'
        }
    ],
    series: [
        {
            name: '<?=Date('Y')-2?>',
            type: 'line',
            data: <?php echo ('['.$graficoanom2[0]->total.','.$graficoanom2[1]->total.','.$graficoanom2[2]->total.','.$graficoanom2[3]->total.','.$graficoanom2[4]->total.','.$graficoanom2[5]->total.','.$graficoanom2[6]->total.','.$graficoanom2[7]->total.','.$graficoanom2[8]->total.','.$graficoanom2[9]->total.','.$graficoanom2[10]->total.','.$graficoanom2[11]->total.']');?>
        },
        {
            name: '<?=Date('Y')-1?>',
            type: 'line',
            data: <?php echo ('['.$graficoanom1[0]->total.','.$graficoanom1[1]->total.','.$graficoanom1[2]->total.','.$graficoanom1[3]->total.','.$graficoanom1[4]->total.','.$graficoanom1[5]->total.','.$graficoanom1[6]->total.','.$graficoanom1[7]->total.','.$graficoanom1[8]->total.','.$graficoanom1[9]->total.','.$graficoanom1[10]->total.','.$graficoanom1[11]->total.']');?>
        },
        {
            name: '<?=Date('Y')?>',
            type: 'line',
            data: <?php echo ('['.$graficoanoatual[0]->total.','.$graficoanoatual[1]->total.','.$graficoanoatual[2]->total.','.$graficoanoatual[3]->total.','.$graficoanoatual[4]->total.','.$graficoanoatual[5]->total.','.$graficoanoatual[6]->total.','.$graficoanoatual[7]->total.','.$graficoanoatual[8]->total.','.$graficoanoatual[9]->total.','.$graficoanoatual[10]->total.','.$graficoanoatual[11]->total.']');?>
        },
        {
            name: 'Média',
            type: 'line',
            data: <?php echo ('['.$media[0].','.$media[1].','.$media[2].','.$media[3].','.$media[4].','.$media[5].','.$media[6].','.$media[7].','.$media[8].','.$media[9].','.$media[10].','.$media[11].']');?>
        }
    ]
};

myChart2.setOption(option);
    myChart2.resize();

    // Resize chart
    // ------------------------------

    $(function () {

        // Resize chart on menu width change and window resize
        $(window).on('resize', resize);
        $(".menu-toggle").on('click', resize);

        // Resize function
        function resize() {
            setTimeout(function() {

                // Resize chart
                myChart2.resize();
            }, 200);
        }
    });
</script>
<script>
var myChart3 = echarts.init(document.getElementById('consumovspagacum'));

option = {
    tooltip: {
        trigger: 'axis',
        axisPointer: {
            type: 'cross',
            crossStyle: {
                color: '#999'
            }
        }
    },
    legend: {
        data:[<?='\''.Date('Y').'\''.','.'\''.(Date('Y')-1).'\''.','.'\''.(Date('Y')-2).'\''?>,'Média']
    },
    xAxis: [
        {
            type: 'category',
            axisTick: {show: false},
            data: ['Jan', 'Fev', 'Mar', 'Abr', 'Mai', 'Jun', 'Jul', 'Ago', 'Set', 'Out', 'Nov', 'Dez']
        }
    ],
    yAxis: {
        name: 'R$',
        axisLine: {
            show: false
        },
        axisTick: {
            show: true
        },
        axisLabel: {
            textStyle: {
                color: '#000'
            }
        }
    },
    color: ['#F98E76', '#16D39A', '#2DCEE3','#000000'],
    dataZoom: [
        {
            type: 'inside'
        }
    ],/*
    series: [
        {
            type: 'bar',
            data: data
        }
    ]*/
    series: [
        {
            name: '<?=Date('Y')-2?>',
            type: 'line',
            data: <?php echo ('['.$acumanom2[0]->total.','.$acumanom2[1]->total.','.$acumanom2[2]->total.','.$acumanom2[3]->total.','.$acumanom2[4]->total.','.$acumanom2[5]->total.','.$acumanom2[6]->total.','.$acumanom2[7]->total.','.$acumanom2[8]->total.','.$acumanom2[9]->total.','.$acumanom2[10]->total.','.$acumanom2[11]->total.']');?>
        },
        {
            name: '<?=Date('Y')-1?>',
            type: 'line',
            data: <?php echo ('['.$acumanom1[0]->total.','.$acumanom1[1]->total.','.$acumanom1[2]->total.','.$acumanom1[3]->total.','.$acumanom1[4]->total.','.$acumanom1[5]->total.','.$acumanom1[6]->total.','.$acumanom1[7]->total.','.$acumanom1[8]->total.','.$acumanom1[9]->total.','.$acumanom1[10]->total.','.$acumanom1[11]->total.']');?>
        },
        {
            name: '<?=Date('Y')?>',
            type: 'line',
            data: <?php echo ('['.$acumanoatual[0]->total.','.$acumanoatual[1]->total.','.$acumanoatual[2]->total.','.$acumanoatual[3]->total.','.$acumanoatual[4]->total.','.$acumanoatual[5]->total.','.$acumanoatual[6]->total.','.$acumanoatual[7]->total.','.$acumanoatual[8]->total.','.$acumanoatual[9]->total.','.$acumanoatual[10]->total.','.$acumanoatual[11]->total.']');?>
        },
        {
            name: 'Média',
            type: 'line',
            data: <?php echo ('['.$acummedia[0].','.$acummedia[1].','.$acummedia[2].','.$acummedia[3].','.$acummedia[4].','.$acummedia[5].','.$acummedia[6].','.$acummedia[7].','.$acummedia[8].','.$acummedia[9].','.$acummedia[10].','.$acummedia[11].']');?>
        }
    ]
};

myChart3.setOption(option);
    myChart3.resize();

    // Resize chart
    // ------------------------------

    $(function () {

        // Resize chart on menu width change and window resize
        $(window).on('resize', resize);
        $(".menu-toggle").on('click', resize);

        // Resize function
        function resize() {
            setTimeout(function() {

                // Resize chart
                myChart3.resize();
            }, 200);
        }
    });
</script>





