<ul class="nav nav-tabs"  role="tablist">
    <li class="nav-item">
        <a class="nav-link active" id="base-tab2" data-toggle="tab" aria-controls="Cadastro" href="#Cadastro" onclick="reloadTable();" role="tab" aria-selected="false">COVID HomeCare</a>
    </li>
    <li class="nav-item">
        <a class="nav-link" id="base-tab1" data-toggle="tab" onclick="reloadTable();loadKanban();" aria-controls="Painel" href="#Painel" role="tab" aria-selected="false">Painel</a>
    </li>
</ul>
<div class="tab-content">
    <div id="Cadastro" class="tab-pane active">
        <div class="card">
            <div class="card-header">
                <h3>Cadastro de Pacientes GPAD: </h3>
            </div>
            <div class="card-body">
            <form action="" method="POST">
                <div class='row'>
                    <div class="col-md-7">
                        <div class="row">
                            <div class='col-md-6'>
                                <b>Número Carteirinha / CPF:</b>
                                <input type="text" name='carteiracpf' required class='form-control'>
                            </div>
                            <div class='col-md-6'>
                                <b>Tipo de Paciente:</b>
                                <select name="tipo" id="tipo" class='form-control'>
                                    <option value="Diag. Suspeito">Diag. Suspeito</option>
                                    <option value="Diag. Confirmado">Diag. Confirmado</option>
                                    <option value="Descartado">Descartado</option>
                                </select>
                            </div>
                            <div class='col-md-6 mt-1'>
                                <b>Grupo de risco:</b>
                                <select name="gruporisco[]" required class="form-control select2" multiple id="gruporisco" style="width:100%">
                                    <option value="Não">Não</option>
                                    <option value="Diabético">Diabético</option>
                                    <option value="Crônico">Crônico</option>
                                    <option value="Hipertenso">Hipertenso</option>
                                    <option value="Problemas Respiratórios">Problemas Respiratórios</option>
                                    <option value="Renal Crônico">Renal Crônico</option>
                                </select>
                            </div>
                            <div class='col-md-6 mt-1'>
                                <b>Tipo Programa:</b>
                                <select name="tipoprograma" id="tipoprograma" class='form-control' required>
                                    <option value="">.: Selecione uma Opção :.</option>
                                    <option value="PID">PID (Programa de Internação Domiciliar)</option>
                                    <option value="PAD">PAD (Programa de Atenção Domiciliar)</option>
                                    <option value="Rota">Rota</option>
                                </select>
                            </div>
                            <div class='col-md-6'><br>
                                <b>Teste Colhido:</b>
                                <label class="switch">
                                    <input type="checkbox" name="testecolhido">
                                    <span class="slider2 round">
                                    </span>
                                </label><br>
                                <b>Ventilação Mecânica:</b>
                                <label class="switch">
                                    <input type="checkbox" name="ventilacao">
                                    <span class="slider2 round">
                                    </span>
                                </label>
                            </div>
                            <div class="col-md-6"><br>
                                <b>Houve Alta:</b>
                                <label class="switch">
                                    <input type="checkbox" name="alta">
                                    <span class="slider2 round">
                                    </span>
                                </label><br>
                                <b>Óbito:</b>
                                <label class="switch">
                                    <input type="checkbox" name="obito">
                                    <span class="slider2 round">
                                    </span>
                                </label>
                            </div>
                            <div class="col-md-6" <?= ($empresa->nome == 'Unimed Natal') ? 'style="display:none"' : ''?>>
                                <b>Último Tratamento:</b>
                                <select name="ultimotratamento" id="ultimotratamento" class="form-control">
                                    <option value="Nenhum">Nenhum</option>
                                    <option value="Quimioterapia">Quimioterapia</option>
                                    <option value="Radioterapia">Radioterapia</option>
                                    <option value="Cirurgia Oncológica">Cirurgia Oncológica</option>
                                </select>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-5">
                        <div class="row">
                            <div class="col-md-12">
                                <b>Observação</b>
                                <textarea name="observacao" rows="4" id="observacao"class="form-control"></textarea>
                            </div>
                            <div class="col-md-12 mt-1">
                                <b>Cód. Teste:</b>
                                <input type="text" class="form-control" name="codigoteste">
                            </div>
                            <div class="col-md-9" <?= ($empresa->nome == 'Unimed Natal') ? 'style="display:none"' : ''?>>
                                <b>Data do Último Tratamento:</b>
                                <input type="date" name="data_ultimotratamento" class="form-control">
                            </div>
                            <div class="col-md-3">
                                <br>
                                <button type='submit' class="btn btn-primary">Enviar</button>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-7">
                        
                    </div>
                </div>
                </form>
                <br>
                <br>
                <hr>
                <h3>Pacientes Cadastrados:</h3>
                <table class="table table-striped table-responsive datatable" id="datatablegpad" cellpadding="0" cellspacing="0">
                    <thead>
                        <tr>
                            <th>Carteira / CPF</th>
                            <th>Condição</th>
                            <th>Grupo de Risco</th>
                            <th>Tipo Programa</th>
                            <th>Observação</th>
                            <th>Data Cadastro</th>
                            <th>Ventilação Mecânica</th>
                            <th>Teste Colhido</th>
                            <th>Houve Alta</th>
                            <th>Usuário de Cadastro</th>
                        </tr>
                    </thead>
                    <tbody>
                    <?php foreach ($pacientes as $item): ?>
                        <tr style="cursor:pointer" data-target="#modal" data-toggle="modal" target="_BLANK" href="<?=$this->request->getAttribute('base')?>/adm/homecare/cadastromodal/<?=$item->pacientes_homecareid?>">
                            <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$item->carteiracpf?></td>
                            <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$item->tipo?></td>
                            <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$item->gruporisco ?? $item->gruporisco2?></td>
                            <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$item->tipoprograma?></td>
                            <td style="word-wrap: break-word;"><?=$item->observacao?></td>
                            <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$this->Custom->formatDataHora($item->datacadastro)?></td>
                            <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$this->Custom->toSimNao($item->ventilacao)?></td>
                            <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$this->Custom->toSimNao($item->testecolhido)?></td>
                            <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$this->Custom->toSimNao($item->alta)?></td>
                            <td style="white-space: nowrap; padding: 0;text-align:center;"><?=$item->usuariocadastronome?></td>
                        </tr>
                    <?php endforeach; ?>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div id="Painel" class="tab-pane">
        <div id="arenacontentkanbangpad"></div>
    </div>
</div>


<script>

function reloadTable() {
    $('#datatablegpad').DataTable( 
    {
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
            decimal: ",",
            thousands: "."
        },
        dom: 'Bfrtip',
        buttons: [
        {
            extend: 'copy',
            text: 'Copiar',
            footer: true
        },
        {
            extend: 'print',
            text: 'Imprimir',
            footer: true
        },
        {
            extend: 'excel',
            filename: 'FlyMed',
            text: 'Excel',
            footer: true
        },
        {
            extend: 'pdf',
    //Name the pdf
    filename: 'FlyMed Relação de Pacientes',
    text: 'PDF',
    orientation:'portrait',        
    title:'',    
    messageTop: 'Corps Teknologi - Analytics para Gestão Inteligente \n Emitido em: <?=Date('d/m/y H:i:s')?> \n Flymed',
    pageSize:'A4',
    footer: true
    }
    ],
    responsive: false,
    destroy: true,
    retrieve: false,
    paging : true,
    "pageLength":10,
    "order": [[ 1, "desc" ]],
    "scrollX" : true,
    fixedHeader: {
        header: false,
        footer: false
    },
    "initComplete": function() {
        window.dispatchEvent(new Event('resize'));
    }
    } 
    );
}
function loadKanban(){
    var url =  encodeURI("kanbangpad");
    $('#loading').show();
    $('#arenacontentkanbangpad').load("../homecare/"+url,function(){
        $('#loading').hide();
    });
}

$(document).ready(
    function () {
        reloadTable();
		$('tr[data-toggle="modal"]').on('click', function(e){
			$('.modal-body').html('<div style="text-align:center"><i class="fa fa-refresh fa-spin"></i></div>');
			e.preventDefault();
			$('#modal').modal('show').find('.modal-body').load($(this).attr('href'),function(responseText, textStatus, req){
			if (textStatus == "error") {
				alert('Sua consulta retornou um número muito grande de registros. Tente um período menor.');
				$('[data-dismiss="modal"]').click();
			}
		});
			$('#loading').hide();
		});
		
		$('button[data-dismiss="modal"]').on('click', function(e){
			$('.modal-body').html("");
		});
	});

	$(function() {
		$('tr[data-toggle="modal"]').on('click', function(e){
			$('.modal-body').html('<div style="text-align:center"><i class="fa fa-refresh fa-spin"></i></div>');
			e.preventDefault();
			$('#modal').modal('show').find('.modal-body').load($(this).attr('href'),function(responseText, textStatus, req){
			if (textStatus == "error") {
				alert('Sua consulta retornou um número muito grande de registros. Tente um período menor.');
				$('[data-dismiss="modal"]').click();
			}
		});
			$('#loading').hide();
		});
		
		$('button[data-dismiss="modal"]').on('click', function(e){
			$('.modal-body').html("");
		});
	});

</script>