<?php

?>
<div class="card">
    <div class="card-header">
        <h3>Relatórios</h3>
    </div>
    <div class="card-body">
            <div class="row">
                <div class="col-md-6">
                    <b>Relatório</b>
                    <select id="selectrelatorio" onchange="mostrarFiltros(this)" class="form-control">
                        <option value="-1">.: ESCOLHA O RELATÓRIO :.</option>                       
                        <option value="relconfirmado">Casos Confirmados Covid-19</option>
                        <option value="relsuspeitos">Casos Suspeitos Covid-19</option>
                        <option value="reltmpmediopermhosp" id="reltmpmediopermhosp">Tempo Médio de Permanência por Hospital</option>
                        <option value="reltmpmediopermpac">Tempo de Permanência por Paciente</option>                       
                        <option value="reltmpmediopermpacuti">Tempo de Permanência por Paciente em UTI</option>                       
                    </select>
                
                    
                </div>
                <div class="col-md-4" id="periodo">
                    <b>Período</b>
                    <div class='input-group'>
                        <input value="<?=date('d/m/Y').' - '.date('d/m/Y')?>" name="periodo" id="filtroperiodo" type='text' class="form-control shawCalRanges" />
                    </div>
                </div>
                <div class="col-md-2" style="margin-top: 20px">
                    <button class="btn btn-primary" onclick="abrirrelatorio()">Abrir</button>
                </div>
            </div>
            
            <hr>
            <div id="divrelatorio" style="width:100%">
            </div>
            
    </div>
</div>
<script>

    function mostrarFiltros(who) {
        let rel = who.selectedOptions[0]
        if (rel.value == 'reltmpmediopermhosp' || rel.value == 'reltmpmediopermpac' || rel.value == 'reltmpmediopermpacuti') {
            $('#periodo').hide();
        } else {
            $('#periodo').show();
        }
    }
    
    function abrirrelatorio(){
        var relatorio = $('#selectrelatorio').val();
        if(relatorio == '-1'){
            alert('Escolha o relatório');
            return;
        }
        
        var periodo    = ($('#filtroperiodo').length == 0) ? '' : $('#filtroperiodo').val();
        
        var params = "";
        params=params+ 'periodo='+periodo;
        
        var url = encodeURI('relatorio/'+relatorio+'?'+params);
        $('#loading').show();
        $('#divrelatorio').load(url,function(responseText, textStatus, req){
            $('#loading').hide();
            if (textStatus == "error") {
                //alert('Não pudemos completar a solicitação');
                $('#divrelatorio').html(responseText);
            }
        })
    }

</script>
<script>
    setTimeout(function() {
        var f = "DD/MM/Y";
        $('.shawCalRanges').daterangepicker({
            ranges: {
                'Hoje': [moment().format(f), moment().format(f)],
                'Ontem': [moment().subtract(1, 'days').format(f), moment().subtract(1, 'days').format(f)],
                'Últimos 7 dias': [moment().subtract(6, 'days').format(f), moment().format(f)],
                'Esse mês': [moment().startOf('month').format(f), moment().endOf('month').format(f)],
                'Mês passado': [moment().subtract(1, 'month').startOf('month').format(f), moment().subtract(1, 'month').endOf('month').format(f)],
                'Esse ano': [moment().startOf('year').format(f), moment().endOf('year').format(f)],
                'Ano passado': [moment().subtract(1, 'year').startOf('year').format(f), moment().subtract(1, 'year').endOf('year').format(f)]
            },
            locale: {
                format: 'DD/MM/YYYY',
                applyLabel: "Ok",
                cancelLabel: 'Cancelar',
                startLabel: 'Início',
                endLabel: 'Fim',
                customRangeLabel: 'Período',
                daysOfWeek: ['Dom', 'Seg', 'Ter', 'Qua', 'Qui', 'Sex','Sáb'],
                monthNames: ['Janeiro','Fevereiro','Março','Abril','Maio','Junho','Julho','Agosto','Setembro','Outubro','Novembro','Dezembro'],
                firstDay: 1
            },
             alwaysShowCalendars: true,
        });
    }, 1000);
</script>