<div class="card">
    <div class="card-header">
        <h3>Relatório de Ligações dos Pacientes</h3>
    </div>
    <div class="card-body">
        <table class="table datatable table-responsive table-stripped" id="datatablerelatorio">
            <thead>
                <th>Carteirinha/CPF</th>
                <th>Motivo Medilar</th>
                <th>Conduta Medilar</th>
                <th>Data Atendimento Medilar</th>
                <th>Entrou em Hospital</th>
                <th>Hospital</th>
                <th>Conduta Hospital</th>
                <th>Data Atendimento Hospital</th>
            </thead>
            <tbody>
            <?php foreach ($relatorio as $item): ?>
                <tr>
                    <td><?=$item->carteirinha?></td>
                    <td><?=$item->motivo_Medilar?></td>
                    <td><?=$item->conduta_Medilar?></td>
                    <td><?=$this->Custom->formatDataHora($item->data_atend_Medilar)?></td>
                    <td><?=$item->entradaHospital?></td>
                    <td><?=$item->HOSPITAL?></td>
                    <td><?=$item->conduta_Hospital?></td>
                    <td><?=$this->Custom->formatData($item->data_atend_Hospital)?></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<script>

$(document).ready(
    $('#datatablerelatorio').DataTable( 
    {
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
            decimal: ",",
            thousands: "."
        },
        dom: 'Bfrtip',
                buttons: [
                {
                    extend: 'copy',
                    text: 'Copiar',
                    footer: true
                },
                {
                    extend: 'print',
                    text: 'Imprimir',
                    footer: true
                },
                {
                    extend: 'excel',
                    filename: 'FlyMed',
                    text: 'Excel',
                    footer: true
                },
                {
                    extend: 'pdf',
            //Name the pdf
            filename: 'FlyMed Relação das ligações dos Pacientes',
            text: 'PDF',
            orientation:'landscape',
            title:'',
            messageTop: 'Corps Teknologi - Analytics para Gestão Inteligente \n Emitido em: <?=Date('d/m/y H:i:s')?> - usuário: <?=$usuario->nome?> \n Flymed - Unimed Natal \n Número de Registros: <?=count($relatorio)?>',

            pageSize:'A4',
            footer: true
            }
            ],
    responsive: false,
    retrieve: false,
    paging : true,
    destroy: true,
    order:[],
    "pageLength":10,
    "scrollX" : true,
    fixedHeader: {
        header: false,
        footer: false
    },
    "initComplete": function() {
        window.dispatchEvent(new Event('resize'));
    }
    } 
    ));
</script>