<?php ?>

<div class="card">
    <div class="card-header">
        <h3>Relatório Casos Suspeitos COVID-19</h3>
    </div>
    <div class="card-body">
        <table style="font-size: 11px" class="table datatable table-responsive table-stripped" id="datatablerelatorio">
            <thead>
                <th>Carteirinha/CPF</th>
                <th>Sexo</th>
                <th>Idade</th>
                <th>Local</th>
                <th>Data</th>
                <th>Hospital</th>
                <th>Ventilação</th>
                <th>Alta</th>
                <th>Óbito</th>
                <th>Usuário Cadastro</th>
            </thead>
            <tbody>
            <?php foreach ($relatorio as $item): ?>
                <tr>
                    <td><?=$item->carteiracpf?></td>
                    <td><?=$item->sexo?></td>
                    <td><?=$item->idade?></td>
                    <td class="text-center"><?=$item->local?></td>
                    <td><?=$this->Custom->formatDataHora($item->cadastro)?></td>
                    <td><?=$item->hospital?></td>
                    <td class="text-center"><?=($item->ventilacao == 1) ? '<span class="badge badge-success">Sim</span>' : '<span class="badge badge-danger">Não</span>'?></td>
                    <td class="text-center"><?=($item->alta == 1) ? '<span class="badge badge-success">Sim</span>' : '<span class="badge badge-danger">Não</span>'?></td>
                    <td class="text-center"><?=($item->obito == 1) ? '<span class="badge badge-success">Sim</span>' : '<span class="badge badge-danger">Não</span>'?></td>
                    <td>
                        <?php if (strlen($item->usuariocadastronome) > 0) {
                            echo $item->usuariocadastronome;
                        } ?>
                        </td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<script>

$(document).ready(
    $('#datatablerelatorio').DataTable( 
    {
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
            decimal: ",",
            thousands: "."
        },
        dom: 'Bfrtip',
                buttons: [
                {
                    extend: 'copy',
                    text: 'Copiar',
                    footer: true
                },
                {
                    extend: 'print',
                    text: 'Imprimir',
                    footer: true
                },
                {
                    extend: 'excel',
                    filename: 'FlyMed',
                    text: 'Excel',
                    footer: true
                },
                {
                    extend: 'pdf',
            //Name the pdf
            filename: 'FlyMed Pacientes Covid-19',
            text: 'PDF',
            orientation:'portrait',
            title:'',
            messageTop: 'Corps Teknologi - Analytics para Gestão Inteligente \n Emitido em: <?=Date('d/m/y H:i:s')?> - Usuário: <?=$usuario->nome?> \n Flymed - Unimed Natal \n Número de Registros: <?=count($relatorio)?>',

            pageSize:'A4',
            footer: true
            }
            ],
    responsive: false,
    retrieve: false,
    paging : false,
    destroy: true,
    order:[],
    "pageLength":10,
    "scrollX" : true,
    fixedHeader: true,
    "initComplete": function() {
        window.dispatchEvent(new Event('resize'));
    }
    } 
    ));
$('.datatable td').css('padding','3px');
</script>
