<?php ?>

<div class="card">
    <div class="card-header">
        <h3>Relatório Permanência Média por Hospital</h3>
    </div>
    <div class="card-body">
        <table style="font-size: 11px" class="table datatable table-responsive table-stripped" id="datatablerelatorio">
            <thead>
                <th>Hospital</th>
                <th>Permanência <br> Média UTI <br> (Dias)</th>
                <th>Permanência <br> Média Hosp. <br> (Dias)</th>
                <th>Qtd. Conf.</th>
                <th>Qtd. Susp.</th>
                <th>Qtd. Alta</th>
                <th>Qtd. Óbito</th>
                <th>Última Atualização</th>
            </thead>
            <tbody>
            <?php foreach ($relatorio as $item): ?>
                <tr>
                    <td><?=$item->hospital?></td>
                    <td><?=$this->Custom->toFloat($item->diasuti)?></td>
                    <td><?=$this->Custom->toFloat($item->diasinternado)?></td>
                    <td><?=$item->confirmados?></td>
                    <td><?=$item->suspeitos?></td>
                    <td><?=$item->alta?></td>
                    <td><?=$item->obito?></td>
                    <td><?=$this->Custom->formatDataHora($item->ultimaatualizacao)?></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<script>

$(document).ready(
    $('#datatablerelatorio').DataTable( 
    {
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
            decimal: ",",
            thousands: "."
        },
        dom: 'Bfrtip',
                buttons: [
                {
                    extend: 'copy',
                    text: 'Copiar',
                    footer: true
                },
                {
                    extend: 'print',
                    text: 'Imprimir',
                    footer: true
                },
                {
                    extend: 'excel',
                    filename: 'FlyMed',
                    text: 'Excel',
                    footer: true
                },
                {
                    extend: 'pdf',
            //Name the pdf
            filename: 'FlyMed Pacientes Covid-19',
            text: 'PDF',
            orientation:'portrait',
            title:'',
            messageTop: 'Corps Teknologi - Analytics para Gestão Inteligente \n Emitido em: <?=Date('d/m/y H:i:s')?> - Usuário: <?=$usuario->nome?> \n Flymed - Unimed Natal \n Número de Registros: <?=count($relatorio)?>',

            pageSize:'A4',
            footer: true
            }
            ],
        responsive: false,
        retrieve: false,
        paging : false,
        destroy: true,
        order:[],
        "pageLength":10,
        "scrollX" : true,
        fixedHeader: true,
        "initComplete": function() {
            window.dispatchEvent(new Event('resize'));
        }
    } 
    ));
$('.datatable td').css('padding','3px');
</script>
