<?php ?>

<div class="card">
    <div class="card-header">
        <h3>Relatório de Ocupação da UTI por Paciente</h3>
    </div>
    <div class="card-body">
        <table style="font-size: 11px" class="table datatable table-responsive table-stripped" id="datatablerelpac">
            <thead>
                <th>Prontuário</th>
                <th>Carteirinha/CPF</th>
                <th>Hospital</th>
                <th>Data de Entrada</th>
                <th>Data de Saída</th>
                <th>Permanência <br> UTI (Dias)</th>
            </thead>
            <tbody>
            <?php foreach ($array as $item): ?>
                <tr style="cursor:pointer" data-target="#modal" data-toggle="modal" target="_BLANK" href="<?=$this->request->getAttribute('base')?>/adm/dashboardcorona/modalentrada/<?=$item->entradapacienteid_gruporisco?>/1">
                    <td><?=$item->prontuario?></td>
                    <td><?=$item->carteiracpf?></td>
                    <td><?=$item->hospital?></td>
                    <td><?=$this->Custom->formatDataHora($item->data_entrada)?></td>
                    <td><?=($item->data_saida == '-') ? '--' : $this->Custom->formatDataHora($item->data_saida)?></td>
                    <td><?php 
                        if ($item->data_saida == '-') {
                            $data1 = new DateTime(Date('Y-m-d H:i:s', strtotime($item->data_entrada))); $data2 = new DateTime(Date('Y-m-d H:i:s', strtotime(Date('Y-m-d'))));
                            echo $data2->diff($data1)->days;
                        } else {
                            $data1 = new DateTime(Date('Y-m-d H:i:s', strtotime($item->data_entrada))); $data2 = new DateTime(Date('Y-m-d H:i:s', strtotime($item->data_saida)));
                            echo $data2->diff($data1)->days;
                        }
                    ?> Dia(s)</td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>

<script>

$(document).ready(  function () {  
    $('#datatablerelpac').DataTable( 
    {
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
            decimal: ",",
            thousands: "."
        },
        dom: 'Bfrtip',
        buttons: [
            {
                extend: 'copy',
                text: 'Copiar',
                footer: true
            },
            {
                extend: 'print',
                text: 'Imprimir',
                footer: true
            },
            {
                extend: 'excel',
                filename: 'FlyMed',
                text: 'Excel',
                footer: true
            },
            {
                extend: 'pdf',
                //Name the pdf
                filename: 'FlyMed Pacientes Covid-19',
                text: 'PDF',
                orientation:'portrait',
                title:'',
                messageTop: 'Corps Teknologi - Analytics para Gestão Inteligente \n Emitido em: <?=Date('d/m/y H:i:s')?> - Usuário: <?=$usuario->nome?> \n Flymed - Unimed Natal \n Número de Registros: <?=count($array)?>',

                pageSize:'A4',
                footer: true
            }
        ],
    responsive: false,
    retrieve: false,
    paging : false,
    "pageLength":50,
    destroy: true,
    order:[],
    "scrollX" : true,
    fixedHeader: true,
    "initComplete": function() {
        window.dispatchEvent(new Event('resize'));
    }
    } 
    );
    
	$(function() {
		$('tr[data-toggle="modal"]').on('click', function(e){
			$('.modal-body').html('<div style="text-align:center"><i class="fa fa-refresh fa-spin"></i></div>');
			e.preventDefault();
			$('#modal').modal('show').find('.modal-body').load($(this).attr('href'),function(responseText, textStatus, req){
			if (textStatus == "error") {
				alert('Sua consulta retornou um número muito grande de registros. Tente um período menor.');
				$('[data-dismiss="modal"]').click();
			}
		});
			$('#loading').hide();
		});
		
		$('button[data-dismiss="modal"]').on('click', function(e){
			$('.modal-body').html("");
		});
	});
});
$('.datatable td').css('padding','3px');
</script>


<script>
	$(function() {
		$('tr[data-toggle="modal"]').on('click', function(e){
			$('.modal-body').html('<div style="text-align:center"><i class="fa fa-refresh fa-spin"></i></div>');
			e.preventDefault();
			$('#modal').modal('show').find('.modal-body').load($(this).attr('href'),function(responseText, textStatus, req){
			if (textStatus == "error") {
				alert('Sua consulta retornou um número muito grande de registros. Tente um período menor.');
				$('[data-dismiss="modal"]').click();
			}
		});
			$('#loading').hide();
		});
		
		$('button[data-dismiss="modal"]').on('click', function(e){
			$('.modal-body').html("");
		});
	});
	</script>