<div class="card">
    <div class="card-header">
        <h3>Edição de TeleAtendimento</h3>
    </div>
    <div class="card-body">
        <h4 class="mt-1">Selecione um Atendimento para edição</h4>
        <table class="table table-stripped table-responsive datatable mt-1" id="datatableedicao">
            <thead>
                <th>Data Atendimento</th>
                <th>Paciente</th>
                <th>Sintomas</th>
                <th>Motivo</th>
                <th>Observação</th>
                <th>Direcionamento</th>
                <th>Atendente</th>
            </thead>
            <tbody>
            <?php foreach ($atendimentos as $item): ?>
                <tr style="cursor:pointer" data-target="#modal" data-toggle="modal" target="_BLANK" href="<?=$this->request->getAttribute('base')?>/adm/telemedicina/modaledicao/<?=$item->atendimentoid2?>">
                    <td><?=$this->Custom->formatDataHora($item->datahora)?></td>
                    <td><?=$item->nome?></td>
                    <td><?=$item->sintomas?></td>
                    <td><?=$item->motivo2?></td>
                    <td><?=$item->observacao?></td>
                    <td><?=$item->direcionamento?></td>
                    <td><?=$item->usuariocadastro?></td>
                </tr>
            <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div> 

<script>
$(document).ready(function ()  {
    $('#datatableedicao').DataTable( 
    {
        language: {
            url: "//cdn.datatables.net/plug-ins/1.10.16/i18n/Portuguese-Brasil.json",
            decimal: ",",
            thousands: "."
        },
        dom: 'Bfrtip',
        buttons: [],
    responsive: false,
    retrieve: false,
    paging : true,
    destroy:true,
    "pageLength":10,
    "order": [],
    "Aasorting":[],
    fixedHeader: {
        header: false,
        footer: false
    },
    "initComplete": function() {
        window.dispatchEvent(new Event('resize'));
    }
    } 
    );
    
	$(function() {
		$('tr[data-toggle="modal"]').on('click', function(e){
			$('.modal-body').html('<div style="text-align:center"><i class="fa fa-refresh fa-spin"></i></div>');
			e.preventDefault();
			$('#modal').modal('show').find('.modal-body').load($(this).attr('href'),function(responseText, textStatus, req){
			if (textStatus == "error") {
				alert('Sua consulta retornou um número muito grande de registros. Tente um período menor.');
				$('[data-dismiss="modal"]').click();
			}
		});
			$('#loading').hide();
		});
		
		$('button[data-dismiss="modal"]').on('click', function(e){
			$('.modal-body').html("");
		});
	});
    })
    
	$(function() {
		$('tr[data-toggle="modal"]').on('click', function(e){
			$('.modal-body').html('<div style="text-align:center"><i class="fa fa-refresh fa-spin"></i></div>');
			e.preventDefault();
			$('#modal').modal('show').find('.modal-body').load($(this).attr('href'),function(responseText, textStatus, req){
			if (textStatus == "error") {
				alert('Sua consulta retornou um número muito grande de registros. Tente um período menor.');
				$('[data-dismiss="modal"]').click();
			}
		});
			$('#loading').hide();
		});
		
		$('button[data-dismiss="modal"]').on('click', function(e){
			$('.modal-body').html("");
		});
	});
</script>